/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.UserApplication;
import org.apache.cxf.jaxrs.model.UserOperation;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public final class SwaggerUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(ResourceUtils.class);
    private static final Map<String, String> SWAGGER_TYPE_MAP = new HashMap<String, String>();

    private SwaggerUtils() {
    }

    public static UserApplication getUserApplication(String loc) {
        return SwaggerUtils.getUserApplication(loc, BusFactory.getThreadDefaultBus());
    }

    public static UserApplication getUserApplication(String loc, Bus bus) {
        try {
            InputStream is = ResourceUtils.getResourceStream((String)loc, (Bus)bus);
            if (is == null) {
                return null;
            }
            return SwaggerUtils.getUserApplicationFromStream(is);
        }
        catch (Exception ex) {
            LOG.warning("Problem with processing a user model at " + loc);
            return null;
        }
    }

    public static UserApplication getUserApplicationFromStream(InputStream is) throws IOException {
        return SwaggerUtils.getUserApplicationFromJson(IOUtils.readStringFromStream((InputStream)is));
    }

    public static UserApplication getUserApplicationFromJson(String json) {
        JsonMapObjectReaderWriter reader = new JsonMapObjectReaderWriter();
        Map map = reader.fromJson(json);
        UserApplication app = new UserApplication();
        String relativePath = (String)map.get("basePath");
        app.setBasePath(StringUtils.isEmpty((String)relativePath) ? "/" : relativePath);
        LinkedHashMap userOpsMap = new LinkedHashMap();
        HashSet<String> tags = new HashSet<String>();
        List tagsProp = CastUtils.cast((List)((List)map.get("tags")));
        if (tagsProp != null) {
            for (Map map2 : tagsProp) {
                tags.add((String)map2.get("name"));
            }
        } else {
            tags.add("");
        }
        for (String string : tags) {
            userOpsMap.put(string, new LinkedList());
        }
        Map paths = CastUtils.cast((Map)((Map)map.get("paths")));
        for (Map.Entry entry : paths.entrySet()) {
            String operPath = (String)entry.getKey();
            Map operations = (Map)entry.getValue();
            for (Map.Entry operEntry : operations.entrySet()) {
                UserOperation userOp = new UserOperation();
                userOp.setVerb(((String)operEntry.getKey()).toUpperCase());
                Map oper = CastUtils.cast((Map)((Map)operEntry.getValue()));
                List opTags = CastUtils.cast((List)((List)oper.get("tags")));
                String opTag = opTags == null ? "" : (String)opTags.get(0);
                String realOpPath = operPath.equals("/" + opTag) ? "/" : operPath.substring(opTag.length() + 1);
                userOp.setPath(realOpPath);
                userOp.setName((String)oper.get("operationId"));
                List opProduces = CastUtils.cast((List)((List)oper.get("produces")));
                userOp.setProduces(SwaggerUtils.listToString(opProduces));
                List opConsumes = CastUtils.cast((List)((List)oper.get("consumes")));
                userOp.setConsumes(SwaggerUtils.listToString(opConsumes));
                LinkedList<Parameter> userOpParams = new LinkedList<Parameter>();
                List params = CastUtils.cast((List)((List)oper.get("parameters")));
                for (Map param : params) {
                    String name = (String)param.get("name");
                    String paramType = (String)param.get("in");
                    ParameterType pType = "body".equals(paramType) ? ParameterType.REQUEST_BODY : ("formData".equals(paramType) ? ParameterType.FORM : ParameterType.valueOf((String)paramType.toUpperCase()));
                    Parameter userParam = new Parameter(pType, name);
                    SwaggerUtils.setJavaType(userParam, (String)param.get("type"));
                    userOpParams.add(userParam);
                }
                if (!userOpParams.isEmpty()) {
                    userOp.setParameters(userOpParams);
                }
                ((List)userOpsMap.get(opTag)).add(userOp);
            }
        }
        LinkedList<UserResource> linkedList = new LinkedList<UserResource>();
        for (Map.Entry entry : userOpsMap.entrySet()) {
            UserResource ur = new UserResource();
            ur.setPath("/" + (String)entry.getKey());
            ur.setOperations((List)entry.getValue());
            ur.setName((String)entry.getKey());
            linkedList.add(ur);
        }
        app.setResources(linkedList);
        return app;
    }

    private static void setJavaType(Parameter userParam, String typeName) {
        String javaTypeName = SWAGGER_TYPE_MAP.get(typeName);
        if (javaTypeName != null) {
            try {
                userParam.setJavaType(ClassLoaderUtils.loadClass((String)javaTypeName, SwaggerUtils.class));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static String listToString(List<String> list) {
        if (list != null) {
            StringBuilder sb = new StringBuilder();
            for (String s : list) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(s);
            }
            return sb.toString();
        }
        return null;
    }

    static {
        SWAGGER_TYPE_MAP.put("string", "String");
        SWAGGER_TYPE_MAP.put("integer", "long");
        SWAGGER_TYPE_MAP.put("float", "float");
        SWAGGER_TYPE_MAP.put("double", "double");
        SWAGGER_TYPE_MAP.put("int", "int");
        SWAGGER_TYPE_MAP.put("long", "long");
        SWAGGER_TYPE_MAP.put("byte", "byte");
        SWAGGER_TYPE_MAP.put("boolean", "boolean");
        SWAGGER_TYPE_MAP.put("date", "java.util.Date");
        SWAGGER_TYPE_MAP.put("dateTime", "java.util.Date");
        SWAGGER_TYPE_MAP.put("File", "java.io.InputStream");
        SWAGGER_TYPE_MAP.put("file", "java.io.InputStream");
    }
}

