/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.spring.boot.autoconfigure.micrometer.provider;

import io.micrometer.core.annotation.Timed;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.metrics.micrometer.provider.TimedAnnotationProvider;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotations;

public class SpringBasedTimedAnnotationProvider
implements TimedAnnotationProvider {
    private final ConcurrentHashMap<HandlerMethod, Set<Timed>> timedAnnotationCache = new ConcurrentHashMap();

    public Set<Timed> getTimedAnnotations(Exchange ex, boolean client) {
        HandlerMethod handlerMethod = HandlerMethod.create(ex, client);
        if (handlerMethod == null) {
            return Collections.emptySet();
        }
        Set<Timed> exists = this.timedAnnotationCache.get(handlerMethod);
        if (exists != null) {
            return exists;
        }
        return this.timedAnnotationCache.computeIfAbsent(handlerMethod, method -> {
            Set<Timed> timed = this.findTimedAnnotations(((HandlerMethod)method).getMethod());
            if (timed.isEmpty() && (timed = this.findTimedAnnotations(((HandlerMethod)method).getBeanType())).isEmpty()) {
                return Collections.emptySet();
            }
            return timed;
        });
    }

    Set<Timed> findTimedAnnotations(AnnotatedElement element) {
        return (Set)MergedAnnotations.from((AnnotatedElement)element).stream(Timed.class).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    private static final class HandlerMethod {
        private final Class<?> beanType;
        private final Method method;

        private HandlerMethod(Class<?> beanType, Method method) {
            this.beanType = beanType;
            this.method = method;
        }

        private static HandlerMethod create(Exchange exchange, boolean client) {
            Service service = exchange.getService();
            if (service != null) {
                BindingOperationInfo bop = exchange.getBindingOperationInfo();
                if (bop != null) {
                    MethodDispatcher md = (MethodDispatcher)service.get((Object)MethodDispatcher.class.getName());
                    if (md != null) {
                        Method method = md.getMethod(bop);
                        return new HandlerMethod(method.getDeclaringClass(), method);
                    }
                } else {
                    OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
                    if (ori != null) {
                        return new HandlerMethod(ori.getClassResourceInfo().getResourceClass(), ori.getAnnotatedMethod());
                    }
                }
            }
            return null;
        }

        private Class<?> getBeanType() {
            return this.beanType;
        }

        private Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandlerMethod that = (HandlerMethod)o;
            return Objects.equals(this.beanType, that.beanType) && Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.beanType, this.method);
        }
    }
}

