/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.message;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.deltaspike.core.impl.message.MessageBundleInvocationHandler;
import org.apache.deltaspike.jsf.api.message.JsfMessage;
import org.apache.deltaspike.jsf.impl.message.DefaultJsfMessage;

@ApplicationScoped
public class JsfMessageProducer {
    @Produces
    @Dependent
    public <M> JsfMessage<M> createJsfMessage(InjectionPoint injectionPoint, MessageBundleInvocationHandler invocationHandler) {
        if (!(injectionPoint.getType() instanceof ParameterizedType)) {
            throw new IllegalArgumentException("JsfMessage must be used as generic type");
        }
        ParameterizedType paramType = (ParameterizedType)injectionPoint.getType();
        Type[] actualTypes = paramType.getActualTypeArguments();
        if (actualTypes.length != 1) {
            throw new IllegalArgumentException("JsfMessage must have the MessageBundle as generic type parameter");
        }
        try {
            Class type = (Class)actualTypes[0];
            return this.createJsfMessageFor(injectionPoint, type, invocationHandler);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Incorrect class found when trying to convert to parameterized type", e);
        }
    }

    private <M> JsfMessage<M> createJsfMessageFor(InjectionPoint injectionPoint, Class<M> rawType, MessageBundleInvocationHandler invocationHandler) {
        return new DefaultJsfMessage<M>(rawType, null, invocationHandler);
    }
}

