/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ad_impl;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSync;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncFlag;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncImpl;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.util.Strings;

public class AdDirSyncDecorator
extends ControlDecorator<AdDirSync>
implements AdDirSync {
    private int adDirSyncLength;
    private static final Asn1Decoder decoder = new Asn1Decoder();

    public AdDirSyncDecorator(LdapApiService codec) {
        super(codec, (Control)new AdDirSyncImpl());
    }

    public AdDirSyncDecorator(LdapApiService codec, AdDirSync control) {
        super(codec, (Control)control);
    }

    public int getParentFirst() {
        return ((AdDirSync)this.getDecorated()).getParentFirst();
    }

    public void setParentFirst(int parentFirst) {
        ((AdDirSync)this.getDecorated()).setParentFirst(parentFirst);
    }

    public AdDirSyncFlag getFlag() {
        return ((AdDirSync)this.getDecorated()).getFlag();
    }

    public void setFlag(AdDirSyncFlag flag) {
        ((AdDirSync)this.getDecorated()).setFlag(flag);
    }

    public int getMaxReturnLength() {
        return ((AdDirSync)this.getDecorated()).getMaxReturnLength();
    }

    public void setMaxReturnLength(int maxReturnLength) {
        ((AdDirSync)this.getDecorated()).setMaxReturnLength(maxReturnLength);
    }

    public byte[] getCookie() {
        return ((AdDirSync)this.getDecorated()).getCookie();
    }

    public void setCookie(byte[] cookie) {
        if (!Strings.isEmpty((byte[])cookie)) {
            byte[] copy = new byte[cookie.length];
            System.arraycopy(cookie, 0, copy, 0, cookie.length);
            ((AdDirSync)this.getDecorated()).setCookie(copy);
        } else {
            ((AdDirSync)this.getDecorated()).setCookie(null);
        }
    }

    public int computeLength() {
        this.adDirSyncLength = 1 + TLV.getNbBytes((int)this.getParentFirst()) + BerValue.getNbBytes((int)this.getParentFirst());
        this.adDirSyncLength += 1 + TLV.getNbBytes((int)this.getMaxReturnLength()) + BerValue.getNbBytes((int)this.getMaxReturnLength());
        byte[] cookie = this.getCookie();
        this.adDirSyncLength = cookie == null ? (this.adDirSyncLength += 2) : (this.adDirSyncLength += 1 + TLV.getNbBytes((int)cookie.length) + cookie.length);
        this.valueLength = 1 + TLV.getNbBytes((int)this.adDirSyncLength) + this.adDirSyncLength;
        return this.valueLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04023, (Object[])new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes((int)this.adDirSyncLength));
        BerValue.encode((ByteBuffer)buffer, (int)this.getParentFirst());
        BerValue.encode((ByteBuffer)buffer, (int)this.getMaxReturnLength());
        BerValue.encode((ByteBuffer)buffer, (byte[])this.getCookie());
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes((int)this.adDirSyncLength));
                BerValue.encode((ByteBuffer)buffer, (int)this.getParentFirst());
                BerValue.encode((ByteBuffer)buffer, (int)this.getMaxReturnLength());
                BerValue.encode((ByteBuffer)buffer, (byte[])this.getCookie());
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        AdDirSyncContainer container = new AdDirSyncContainer(this.getCodecService(), this);
        decoder.decode(bb, (Asn1Container)container);
        return this;
    }
}

