/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import java.io.StringReader;
import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.AntlrDnLexer;
import org.apache.directory.api.ldap.model.name.AntlrDnParser;
import org.apache.directory.api.ldap.model.name.Rdn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComplexDnParser {
    ComplexDnParser() {
    }

    void parseDn(String name, List<Rdn> rdns) throws LdapInvalidDnException {
        AntlrDnParser dnParser = new AntlrDnParser(new AntlrDnLexer(new StringReader(name)));
        try {
            dnParser.relativeDistinguishedNames(rdns);
        }
        catch (Exception e) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, e.getMessage(), e);
        }
    }

    void parseRdn(String name, Rdn rdn) throws LdapInvalidDnException {
        AntlrDnParser dnParser = new AntlrDnParser(new AntlrDnLexer(new StringReader(name)));
        try {
            dnParser.relativeDistinguishedName(rdn);
        }
        catch (Exception e) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, e.getMessage(), e);
        }
    }
}

