/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.url;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.exception.LdapUriException;
import org.apache.directory.api.ldap.model.exception.UrlDecoderException;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.Unicode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapUrl {
    public static final String LDAPS_SCHEME = "ldaps://";
    public static final String LDAP_SCHEME = "ldap://";
    public static final LdapUrl EMPTY_URL = new LdapUrl();
    private String scheme;
    private String host;
    private int port;
    private Dn dn;
    private List<String> attributes;
    private SearchScope scope;
    private String filter;
    private List<Extension> extensionList;
    private String string;
    private byte[] bytes;
    private boolean forceScopeRendering;
    private static final Pattern ATTRIBUTE = Pattern.compile("(?:(?:\\d|[1-9]\\d*)(?:\\.(?:\\d|[1-9]\\d*))+)|(?:[a-zA-Z][a-zA-Z0-9-]*)");

    public LdapUrl() {
        this.scheme = LDAP_SCHEME;
        this.host = null;
        this.port = -1;
        this.dn = null;
        this.attributes = new ArrayList<String>();
        this.scope = SearchScope.OBJECT;
        this.filter = null;
        this.extensionList = new ArrayList<Extension>(2);
    }

    private void parse(char[] chars) throws LdapURLEncodingException {
        this.scheme = LDAP_SCHEME;
        this.host = null;
        this.port = -1;
        this.dn = null;
        this.attributes = new ArrayList<String>();
        this.scope = SearchScope.OBJECT;
        this.filter = null;
        this.extensionList = new ArrayList<Extension>(2);
        if (chars == null || chars.length == 0) {
            this.host = "";
            return;
        }
        int pos = 0;
        pos = Strings.areEquals((char[])chars, (int)0, (String)LDAP_SCHEME);
        if (pos == -1 && (pos = Strings.areEquals((char[])chars, (int)0, (String)LDAPS_SCHEME)) == -1) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04398, (Object[])new Object[0]));
        }
        this.scheme = new String(chars, 0, pos);
        if ((pos = this.parseHostPort(chars, pos)) == -1) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04399, (Object[])new Object[0]));
        }
        if (pos == chars.length) {
            return;
        }
        if (!Chars.isCharASCII((char[])chars, (int)pos, (char)'/')) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04400, (Object[])new Object[]{pos, Character.valueOf(chars[pos])}));
        }
        if (++pos == chars.length) {
            return;
        }
        if ((pos = this.parseDN(chars, pos)) == -1) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04401, (Object[])new Object[0]));
        }
        if (pos == chars.length) {
            return;
        }
        if (!Chars.isCharASCII((char[])chars, (int)pos, (char)'?')) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04402, (Object[])new Object[]{pos, Character.valueOf(chars[pos])}));
        }
        ++pos;
        if ((pos = this.parseAttributes(chars, pos)) == -1) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04403, (Object[])new Object[0]));
        }
        if (pos == chars.length) {
            return;
        }
        if (!Chars.isCharASCII((char[])chars, (int)pos, (char)'?')) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04402, (Object[])new Object[]{pos, Character.valueOf(chars[pos])}));
        }
        ++pos;
        if ((pos = this.parseScope(chars, pos)) == -1) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04404, (Object[])new Object[0]));
        }
        if (pos == chars.length) {
            return;
        }
        if (!Chars.isCharASCII((char[])chars, (int)pos, (char)'?')) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04402, (Object[])new Object[]{pos, Character.valueOf(chars[pos])}));
        }
        if (++pos == chars.length) {
            return;
        }
        if ((pos = this.parseFilter(chars, pos)) == -1) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04405, (Object[])new Object[0]));
        }
        if (pos == chars.length) {
            return;
        }
        if (!Chars.isCharASCII((char[])chars, (int)pos, (char)'?')) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04402, (Object[])new Object[]{pos, Character.valueOf(chars[pos])}));
        }
        ++pos;
        if ((pos = this.parseExtensions(chars, pos)) == -1) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04406, (Object[])new Object[0]));
        }
        if (pos == chars.length) {
            return;
        }
        throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04407, (Object[])new Object[0]));
    }

    public LdapUrl(String string) throws LdapURLEncodingException {
        if (string == null) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04408, (Object[])new Object[0]));
        }
        try {
            this.bytes = string.getBytes("UTF-8");
            this.string = string;
            this.parse(string.toCharArray());
        }
        catch (UnsupportedEncodingException uee) {
            throw new LdapURLEncodingException(I18n.err((I18n)I18n.ERR_04409, (Object[])new Object[]{string}));
        }
    }

    private int parseHost(char[] chars, int pos) {
        int start = pos;
        boolean hadDot = false;
        boolean hadMinus = false;
        boolean isHostNumber = true;
        boolean invalidIp = false;
        int nbDots = 0;
        int[] ipElem = new int[4];
        if (Chars.isCharASCII((char[])chars, (int)pos, (char)'-')) {
            return -1;
        }
        while (pos < chars.length && chars[pos] != ':' && chars[pos] != '/') {
            if (Chars.isCharASCII((char[])chars, (int)pos, (char)'.')) {
                if (hadMinus || hadDot) {
                    return -1;
                }
                if (isHostNumber && nbDots < 4 && ipElem[nbDots] > 65535) {
                    invalidIp = true;
                }
                hadDot = true;
                ++nbDots;
                ++pos;
                continue;
            }
            if (hadDot && Chars.isCharASCII((char[])chars, (int)pos, (char)'-')) {
                return -1;
            }
            hadDot = false;
            if (Chars.isDigit((char[])chars, (int)pos)) {
                if (isHostNumber && nbDots < 4) {
                    ipElem[nbDots] = ipElem[nbDots] * 10 + (chars[pos] - 48);
                    if (ipElem[nbDots] > 65535) {
                        invalidIp = true;
                    }
                }
                hadMinus = false;
            } else if (Chars.isAlphaDigitMinus((char[])chars, (int)pos)) {
                isHostNumber = false;
                hadMinus = Chars.isCharASCII((char[])chars, (int)pos, (char)'-');
            } else {
                return -1;
            }
            ++pos;
        }
        if (start == pos) {
            return pos;
        }
        if (isHostNumber) {
            if (nbDots != 3) {
                return -1;
            }
            if (invalidIp) {
                return -1;
            }
        }
        if (hadDot || hadMinus) {
            return -1;
        }
        this.host = new String(chars, start, pos - start);
        return pos;
    }

    private int parsePort(char[] chars, int pos) {
        if (!Chars.isDigit((char[])chars, (int)pos)) {
            return -1;
        }
        this.port = chars[pos] - 48;
        ++pos;
        while (Chars.isDigit((char[])chars, (int)pos)) {
            this.port = this.port * 10 + (chars[pos] - 48);
            if (this.port > 65535) {
                return -1;
            }
            ++pos;
        }
        return pos;
    }

    private int parseHostPort(char[] chars, int pos) {
        int hostPos = pos;
        if ((pos = this.parseHost(chars, pos)) == -1) {
            return -1;
        }
        if (Chars.isCharASCII((char[])chars, (int)pos, (char)':')) {
            if (pos == hostPos) {
                return -1;
            }
            ++pos;
        } else {
            return pos;
        }
        pos = this.parsePort(chars, pos);
        if (pos == -1) {
            return -1;
        }
        return pos;
    }

    private static byte[] getAsciiBytes(String data) throws UrlDecoderException {
        if (data == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04411, (Object[])new Object[0]));
        }
        try {
            return data.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new UrlDecoderException(I18n.err((I18n)I18n.ERR_04413, (Object[])new Object[0]));
        }
    }

    private static byte[] decodeUrl(byte[] bytes) throws UrlDecoderException {
        if (bytes == null) {
            return StringConstants.EMPTY_BYTES;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 37) {
                try {
                    int u = Character.digit((char)bytes[++i], 16);
                    int l = Character.digit((char)bytes[++i], 16);
                    if (u == -1 || l == -1) {
                        throw new UrlDecoderException(I18n.err((I18n)I18n.ERR_04414, (Object[])new Object[0]));
                    }
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new UrlDecoderException(I18n.err((I18n)I18n.ERR_04414, (Object[])new Object[0]));
                }
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    private static String decode(String escaped) throws LdapUriException {
        try {
            byte[] rawdata = LdapUrl.decodeUrl(LdapUrl.getAsciiBytes(escaped));
            return Strings.getString((byte[])rawdata, (String)"UTF-8");
        }
        catch (UrlDecoderException e) {
            throw new LdapUriException(e.getMessage(), e);
        }
    }

    private int parseDN(char[] chars, int pos) {
        int end = pos;
        for (int i = pos; i < chars.length && chars[i] != '?'; ++i) {
            ++end;
        }
        try {
            String dnStr = new String(chars, pos, end - pos);
            this.dn = new Dn(LdapUrl.decode(dnStr));
        }
        catch (LdapUriException ue) {
            return -1;
        }
        catch (LdapInvalidDnException de) {
            return -1;
        }
        return end;
    }

    private void validateAttribute(String attribute) throws LdapURLEncodingException {
        Matcher matcher = ATTRIBUTE.matcher(attribute);
        if (!matcher.matches()) {
            throw new LdapURLEncodingException("Attribute " + attribute + " is invalid");
        }
    }

    private int parseAttributes(char[] chars, int pos) {
        int start = pos;
        int end = pos;
        HashSet<String> hAttributes = new HashSet<String>();
        boolean hadComma = false;
        try {
            for (int i = pos; i < chars.length && chars[i] != '?'; ++i) {
                if (Chars.isCharASCII((char[])chars, (int)i, (char)',')) {
                    hadComma = true;
                    if (end - start == 0) {
                        return -1;
                    }
                    String attribute = null;
                    attribute = new String(chars, start, end - start).trim();
                    if (attribute.length() == 0) {
                        return -1;
                    }
                    try {
                        this.validateAttribute(attribute);
                    }
                    catch (LdapURLEncodingException luee) {
                        return -1;
                    }
                    String decodedAttr = LdapUrl.decode(attribute);
                    if (!hAttributes.contains(decodedAttr)) {
                        this.attributes.add(decodedAttr);
                        hAttributes.add(decodedAttr);
                    }
                    start = i + 1;
                } else {
                    hadComma = false;
                }
                ++end;
            }
            if (hadComma) {
                return -1;
            }
            if (end == start) {
                return end;
            }
            String attribute = null;
            attribute = new String(chars, start, end - start).trim();
            if (attribute.length() == 0) {
                return -1;
            }
            String decodedAttr = LdapUrl.decode(attribute);
            if (!hAttributes.contains(decodedAttr)) {
                this.attributes.add(decodedAttr);
                hAttributes.add(decodedAttr);
            }
            return end;
        }
        catch (LdapUriException ue) {
            return -1;
        }
    }

    private int parseFilter(char[] chars, int pos) {
        int end = pos;
        for (int i = pos; i < chars.length && chars[i] != '?'; ++i) {
            ++end;
        }
        if (end == pos) {
            return end;
        }
        try {
            this.filter = LdapUrl.decode(new String(chars, pos, end - pos));
            FilterParser.parse(null, this.filter);
        }
        catch (LdapUriException ue) {
            return -1;
        }
        catch (ParseException pe) {
            return -1;
        }
        return end;
    }

    private int parseScope(char[] chars, int pos) {
        if (Chars.isCharASCII((char[])chars, (int)pos, (char)'b') || Chars.isCharASCII((char[])chars, (int)pos, (char)'B')) {
            if ((Chars.isCharASCII((char[])chars, (int)(++pos), (char)'a') || Chars.isCharASCII((char[])chars, (int)pos, (char)'A')) && (Chars.isCharASCII((char[])chars, (int)(++pos), (char)'s') || Chars.isCharASCII((char[])chars, (int)pos, (char)'S')) && (Chars.isCharASCII((char[])chars, (int)(++pos), (char)'e') || Chars.isCharASCII((char[])chars, (int)pos, (char)'E'))) {
                this.scope = SearchScope.OBJECT;
                return ++pos;
            }
        } else if (Chars.isCharASCII((char[])chars, (int)pos, (char)'o') || Chars.isCharASCII((char[])chars, (int)pos, (char)'O')) {
            if ((Chars.isCharASCII((char[])chars, (int)(++pos), (char)'n') || Chars.isCharASCII((char[])chars, (int)pos, (char)'N')) && (Chars.isCharASCII((char[])chars, (int)(++pos), (char)'e') || Chars.isCharASCII((char[])chars, (int)pos, (char)'E'))) {
                this.scope = SearchScope.ONELEVEL;
                return ++pos;
            }
        } else if (Chars.isCharASCII((char[])chars, (int)pos, (char)'s') || Chars.isCharASCII((char[])chars, (int)pos, (char)'S')) {
            if ((Chars.isCharASCII((char[])chars, (int)(++pos), (char)'u') || Chars.isCharASCII((char[])chars, (int)pos, (char)'U')) && (Chars.isCharASCII((char[])chars, (int)(++pos), (char)'b') || Chars.isCharASCII((char[])chars, (int)pos, (char)'B'))) {
                this.scope = SearchScope.SUBTREE;
                return ++pos;
            }
        } else {
            if (Chars.isCharASCII((char[])chars, (int)pos, (char)'?')) {
                return pos;
            }
            if (pos == chars.length) {
                return pos;
            }
        }
        return -1;
    }

    private int parseExtensions(char[] chars, int pos) {
        int start = pos;
        boolean isCritical = false;
        boolean isNewExtension = true;
        boolean hasValue = false;
        String extension = null;
        String value = null;
        if (pos == chars.length) {
            return pos;
        }
        try {
            for (int i = pos; i < chars.length; ++i) {
                if (Chars.isCharASCII((char[])chars, (int)i, (char)',')) {
                    if (isNewExtension) {
                        return -1;
                    }
                    if (extension == null) {
                        extension = LdapUrl.decode(new String(chars, start, i - start)).trim();
                    } else {
                        value = LdapUrl.decode(new String(chars, start, i - start)).trim();
                    }
                    Extension ext = new Extension(isCritical, extension, value);
                    this.extensionList.add(ext);
                    isNewExtension = true;
                    hasValue = false;
                    isCritical = false;
                    start = i + 1;
                    extension = null;
                    value = null;
                    continue;
                }
                if (Chars.isCharASCII((char[])chars, (int)i, (char)'=')) {
                    if (hasValue) continue;
                    extension = LdapUrl.decode(new String(chars, start, i - start)).trim();
                    if (extension.length() == 0) {
                        return -1;
                    }
                    hasValue = true;
                    start = i + 1;
                    continue;
                }
                if (Chars.isCharASCII((char[])chars, (int)i, (char)'!')) {
                    if (hasValue) continue;
                    if (!isNewExtension) {
                        return -1;
                    }
                    isCritical = true;
                    ++start;
                    continue;
                }
                isNewExtension = false;
            }
            if (extension == null) {
                extension = LdapUrl.decode(new String(chars, start, chars.length - start)).trim();
            } else {
                value = LdapUrl.decode(new String(chars, start, chars.length - start)).trim();
            }
            Extension ext = new Extension(isCritical, extension, value);
            this.extensionList.add(ext);
            return chars.length;
        }
        catch (LdapUriException ue) {
            return -1;
        }
    }

    public static String urlEncode(String url, boolean doubleEncode) {
        StringBuffer sb = new StringBuffer();
        block4: for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            switch (c) {
                case '!': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '=': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case ']': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '~': {
                    sb.append(c);
                    continue block4;
                }
                case ',': {
                    if (doubleEncode) {
                        sb.append("%2c");
                        continue block4;
                    }
                    sb.append(c);
                    continue block4;
                }
                default: {
                    byte[] bytes = Unicode.charToBytes((char)c);
                    char[] hex = Strings.toHexString((byte[])bytes).toCharArray();
                    for (int j = 0; j < hex.length; ++j) {
                        if (j % 2 == 0) {
                            sb.append('%');
                        }
                        sb.append(hex[j]);
                    }
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.scheme);
        sb.append(this.host == null ? "" : this.host);
        if (this.port != -1) {
            sb.append(':').append(this.port);
        }
        if (this.dn != null) {
            boolean isFirst;
            sb.append('/').append(LdapUrl.urlEncode(this.dn.getName(), false));
            if (this.attributes.size() != 0 || this.forceScopeRendering || this.scope != SearchScope.OBJECT || this.filter != null || this.extensionList.size() != 0) {
                sb.append('?');
                isFirst = true;
                for (String attribute : this.attributes) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(LdapUrl.urlEncode(attribute, false));
                }
            }
            if (this.forceScopeRendering) {
                sb.append('?');
                sb.append(this.scope.getLdapUrlValue());
            } else if (this.scope != SearchScope.OBJECT || this.filter != null || this.extensionList.size() != 0) {
                sb.append('?');
                switch (this.scope) {
                    case ONELEVEL: 
                    case SUBTREE: {
                        sb.append(this.scope.getLdapUrlValue());
                        break;
                    }
                }
                if (this.filter != null || this.extensionList.size() != 0) {
                    sb.append("?");
                    if (this.filter != null) {
                        sb.append(LdapUrl.urlEncode(this.filter, false));
                    }
                    if (this.extensionList.size() != 0) {
                        sb.append('?');
                        isFirst = true;
                        if (this.extensionList.size() != 0) {
                            for (Extension extension : this.extensionList) {
                                if (!isFirst) {
                                    sb.append(',');
                                } else {
                                    isFirst = false;
                                }
                                if (extension.isCritical) {
                                    sb.append('!');
                                }
                                sb.append(LdapUrl.urlEncode(extension.type, false));
                                if (extension.value == null) continue;
                                sb.append('=');
                                sb.append(LdapUrl.urlEncode(extension.value, true));
                            }
                        }
                    }
                }
            }
        } else {
            sb.append('/');
        }
        return sb.toString();
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public Dn getDn() {
        return this.dn;
    }

    public List<Extension> getExtensions() {
        return this.extensionList;
    }

    public Extension getExtension(String type) {
        for (Extension extension : this.getExtensions()) {
            if (!extension.getType().equalsIgnoreCase(type)) continue;
            return extension;
        }
        return null;
    }

    public String getExtensionValue(String type) {
        for (Extension extension : this.getExtensions()) {
            if (!extension.getType().equalsIgnoreCase(type)) continue;
            return extension.getValue();
        }
        return null;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getNbBytes() {
        return this.bytes != null ? this.bytes.length : 0;
    }

    public byte[] getBytesReference() {
        return this.bytes;
    }

    public byte[] getBytesCopy() {
        if (this.bytes != null) {
            byte[] copy = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
            return copy;
        }
        return null;
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LdapUrl other = (LdapUrl)obj;
        return this.toString().equals(other.toString());
    }

    public void setScheme(String scheme) {
        this.scheme = scheme != null && LDAP_SCHEME.equals(scheme) || LDAPS_SCHEME.equals(scheme) ? scheme : LDAP_SCHEME;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port < 1 || port > 65535 ? -1 : port;
    }

    public void setDn(Dn dn) {
        this.dn = dn;
    }

    public void setAttributes(List<String> attributes) {
        if (attributes == null) {
            this.attributes.clear();
        } else {
            this.attributes = attributes;
        }
    }

    public void setScope(int scope) {
        try {
            this.scope = SearchScope.getSearchScope(scope);
        }
        catch (IllegalArgumentException iae) {
            this.scope = SearchScope.OBJECT;
        }
    }

    public void setScope(SearchScope scope) {
        this.scope = scope == null ? SearchScope.OBJECT : scope;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setForceScopeRendering(boolean forceScopeRendering) {
        this.forceScopeRendering = forceScopeRendering;
    }

    public static class Extension {
        private boolean isCritical;
        private String type;
        private String value;

        public Extension(boolean isCritical, String type, String value) {
            this.isCritical = isCritical;
            this.type = type;
            this.value = value;
        }

        public boolean isCritical() {
            return this.isCritical;
        }

        public void setCritical(boolean critical) {
            this.isCritical = critical;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

