/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class NumberSyntaxChecker
extends SyntaxChecker {
    public static final NumberSyntaxChecker INSTANCE = new NumberSyntaxChecker("1.3.6.1.4.1.18060.0.4.0.0.4");

    private NumberSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        block3: for (int i = 0; i < strValue.length(); ++i) {
            switch (strValue.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
                    }
                    return false;
                }
            }
        }
        if (strValue.charAt(0) == '0' && strValue.length() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_13701_SYNTAX_VALID, (Object[])new Object[]{value}));
        }
        return true;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<NumberSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.18060.0.4.0.0.4");
        }

        @Override
        public NumberSyntaxChecker build() {
            return new NumberSyntaxChecker(this.oid);
        }
    }
}

