/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.protocol;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.changepw.ChangePasswordServer;
import org.apache.directory.server.changepw.exceptions.ChangePasswordException;
import org.apache.directory.server.changepw.exceptions.ErrorType;
import org.apache.directory.server.changepw.messages.ChangePasswordErrorModifier;
import org.apache.directory.server.changepw.messages.ChangePasswordRequest;
import org.apache.directory.server.changepw.protocol.ChangePasswordTcpProtocolCodecFactory;
import org.apache.directory.server.changepw.protocol.ChangePasswordUdpProtocolCodecFactory;
import org.apache.directory.server.changepw.service.ChangePasswordContext;
import org.apache.directory.server.changepw.service.ChangePasswordService;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessage;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessageModifier;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePasswordProtocolHandler
implements IoHandler {
    private static final Logger log = LoggerFactory.getLogger(ChangePasswordProtocolHandler.class);
    private ChangePasswordServer config;
    private PrincipalStore store;
    private String contextKey = "context";

    public ChangePasswordProtocolHandler(ChangePasswordServer config, PrincipalStore store) {
        this.config = config;
        this.store = store;
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("{} CREATED:  {}", session.getRemoteAddress(), (Object)session.getTransportMetadata());
        }
        if (session.getTransportMetadata().isConnectionless()) {
            session.getFilterChain().addFirst("codec", new ProtocolCodecFilter(ChangePasswordUdpProtocolCodecFactory.getInstance()));
        } else {
            session.getFilterChain().addFirst("codec", new ProtocolCodecFilter(ChangePasswordTcpProtocolCodecFactory.getInstance()));
        }
    }

    public void sessionOpened(IoSession session) {
        log.debug("{} OPENED", session.getRemoteAddress());
    }

    public void sessionClosed(IoSession session) {
        log.debug("{} CLOSED", session.getRemoteAddress());
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        log.debug("{} IDLE ({})", session.getRemoteAddress(), (Object)status);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        log.debug(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) {
        log.debug("{} RCVD:  {}", session.getRemoteAddress(), message);
        InetAddress clientAddress = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
        ChangePasswordRequest request = (ChangePasswordRequest)message;
        try {
            ChangePasswordContext changepwContext = new ChangePasswordContext();
            changepwContext.setConfig(this.config);
            changepwContext.setStore(this.store);
            changepwContext.setClientAddress(clientAddress);
            changepwContext.setRequest(request);
            session.setAttribute(this.getContextKey(), changepwContext);
            ChangePasswordService.execute(session, changepwContext);
            session.write(changepwContext.getReply());
        }
        catch (KerberosException ke) {
            if (log.isDebugEnabled()) {
                log.warn(ke.getLocalizedMessage(), ke);
            } else {
                log.warn(ke.getLocalizedMessage());
            }
            ErrorMessage errorMessage = this.getErrorMessage(this.config.getServicePrincipal(), ke);
            ChangePasswordErrorModifier modifier = new ChangePasswordErrorModifier();
            modifier.setErrorMessage(errorMessage);
            session.write(modifier.getChangePasswordError());
        }
        catch (Exception e) {
            log.error(I18n.err(I18n.ERR_152, e.getLocalizedMessage()), e);
            session.write(this.getErrorMessage(this.config.getServicePrincipal(), new ChangePasswordException(ErrorType.KRB5_KPASSWD_UNKNOWN_ERROR)));
        }
    }

    public void messageSent(IoSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug("{} SENT:  {}", session.getRemoteAddress(), message);
        }
    }

    protected String getContextKey() {
        return this.contextKey;
    }

    private ErrorMessage getErrorMessage(KerberosPrincipal principal, KerberosException exception) {
        ErrorMessageModifier modifier = new ErrorMessageModifier();
        KerberosTime now = new KerberosTime();
        modifier.setErrorCode(exception.getErrorCode());
        modifier.setExplanatoryText(exception.getLocalizedMessage());
        modifier.setServerPrincipal(principal);
        modifier.setServerTime(now);
        modifier.setServerMicroSecond(0);
        modifier.setExplanatoryData(this.buildExplanatoryData(exception));
        return modifier.getErrorMessage();
    }

    private byte[] buildExplanatoryData(KerberosException exception) {
        short resultCode = (short)exception.getErrorCode();
        byte[] resultString = new byte[]{0};
        if (exception.getExplanatoryData() == null || exception.getExplanatoryData().length == 0) {
            try {
                resultString = exception.getLocalizedMessage().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                log.error(uee.getLocalizedMessage());
            }
        } else {
            resultString = exception.getExplanatoryData();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(256);
        byteBuffer.putShort(resultCode);
        byteBuffer.put(resultString);
        byteBuffer.flip();
        byte[] explanatoryData = new byte[byteBuffer.remaining()];
        byteBuffer.get(explanatoryData, 0, explanatoryData.length);
        return explanatoryData;
    }
}

