/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.AvlTreeImpl;
import org.apache.directory.server.core.avltree.AvlTreeMap;
import org.apache.directory.server.core.avltree.LinkedAvlMapNode;
import org.apache.directory.server.core.avltree.SingletonOrOrderedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlTreeMapImpl<K, V>
implements AvlTreeMap<K, V> {
    private LinkedAvlMapNode<K, V> root;
    private Comparator<K> keyComparator;
    private Comparator<V> valueComparator;
    private LinkedAvlMapNode<K, V> first;
    private LinkedAvlMapNode<K, V> last;
    private boolean allowDuplicates;
    private int size;

    public AvlTreeMapImpl(Comparator<K> keyComparator, Comparator<V> valueComparator) {
        this(keyComparator, valueComparator, false);
    }

    public AvlTreeMapImpl(Comparator<K> keyComparator, Comparator<V> valueComparator, boolean allowDuplicates) {
        this.keyComparator = keyComparator;
        this.valueComparator = valueComparator;
        this.allowDuplicates = allowDuplicates;
    }

    @Override
    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    @Override
    public Comparator<V> getValueComparator() {
        return this.valueComparator;
    }

    @Override
    public V insert(K key, V value) {
        int c;
        LinkedAvlMapNode<K, V> parent = null;
        if (this.root == null) {
            this.root = new LinkedAvlMapNode<K, V>(key, value);
            this.first = this.root;
            this.last = this.root;
            ++this.size;
            return null;
        }
        LinkedAvlMapNode<K, V> node = new LinkedAvlMapNode<K, V>(key, value);
        LinkedAvlMapNode<K, V> temp = this.root;
        ArrayList<LinkedAvlMapNode<K, V>> treePath = new ArrayList<LinkedAvlMapNode<K, V>>();
        while (temp != null) {
            treePath.add(0, temp);
            parent = temp;
            c = this.keyComparator.compare(key, temp.getKey());
            if (c == 0) {
                if (this.allowDuplicates) {
                    return this.insertDupKey(key, value, temp);
                }
                return temp.value.setSingleton(value);
            }
            if (c < 0) {
                temp.isLeft = true;
                temp = temp.getLeft();
                continue;
            }
            temp.isLeft = false;
            temp = temp.getRight();
        }
        c = this.keyComparator.compare(key, parent.getKey());
        if (c < 0) {
            parent.setLeft(node);
        } else {
            parent.setRight(node);
        }
        this.insertInList(node, parent, c);
        treePath.add(0, node);
        this.balance(treePath);
        ++this.size;
        return null;
    }

    private V insertDupKey(K key, V value, LinkedAvlMapNode<K, V> existingNode) {
        AvlTree dupsTree = null;
        if (existingNode.value.isOrderedSet()) {
            dupsTree = existingNode.value.getOrderedSet();
        } else {
            dupsTree = new AvlTreeImpl<V>(this.valueComparator);
            dupsTree.insert(existingNode.value.getSingleton());
            existingNode.value.switchToOrderedSet(dupsTree);
        }
        if (dupsTree.find(value) != null) {
            return value;
        }
        dupsTree.insert(value);
        return null;
    }

    private void removeFromList(LinkedAvlMapNode<K, V> node) {
        if (node.next == null && node.previous == null) {
            this.last = null;
            this.first = null;
        } else if (node.next == null) {
            node.previous.next = null;
            this.last = node.previous;
        } else if (node.previous == null) {
            node.next.previous = null;
            this.first = node.next;
        } else {
            node.previous.next = node.next;
            node.next.previous = node.previous;
        }
    }

    private void insertInList(LinkedAvlMapNode<K, V> node, LinkedAvlMapNode<K, V> parentNode, int pos) {
        if (pos < 0) {
            if (this.last == null) {
                this.last = parentNode;
            }
            if (parentNode.previous == null) {
                this.first = node;
            } else {
                parentNode.previous.next = node;
                node.previous = parentNode.previous;
            }
            node.next = parentNode;
            parentNode.previous = node;
        } else if (pos > 0) {
            if (parentNode.next == null) {
                this.last = node;
            } else {
                parentNode.next.previous = node;
                node.next = parentNode.next;
            }
            node.previous = parentNode;
            parentNode.next = node;
        }
    }

    @Override
    public SingletonOrOrderedSet<V> remove(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        LinkedAvlMapNode<K, V> temp = null;
        List<LinkedAvlMapNode<K, V>> treePath = new ArrayList<LinkedAvlMapNode<K, V>>();
        if ((treePath = this.find(key, this.root, treePath)) == null) {
            return null;
        }
        temp = treePath.remove(0);
        if (temp.isLeaf() && temp == this.root) {
            this.root = null;
        } else {
            this.balanceNodesAfterRemove(treePath, temp);
        }
        --this.size;
        return temp.value;
    }

    @Override
    public V remove(K key, V value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("key or value cannot be null");
        }
        LinkedAvlMapNode<K, V> temp = null;
        List<LinkedAvlMapNode<K, V>> treePath = new ArrayList<LinkedAvlMapNode<K, V>>();
        if ((treePath = this.find(key, this.root, treePath)) == null) {
            return null;
        }
        temp = treePath.remove(0);
        if (this.allowDuplicates) {
            if (temp.value.isOrderedSet()) {
                AvlTree dupsTree = temp.value.getOrderedSet();
                Object removedVal = dupsTree.remove(value);
                if (removedVal != null && !dupsTree.isEmpty()) {
                    return removedVal;
                }
                if (removedVal == null) {
                    return removedVal;
                }
            } else if (this.valueComparator.compare(temp.value.getSingleton(), value) != 0) {
                return null;
            }
        }
        if (temp.isLeaf() && temp == this.root) {
            if (this.allowDuplicates) {
                if (temp.value.isSingleton() || temp.value.getOrderedSet().isEmpty()) {
                    this.root = null;
                }
            } else {
                this.root = null;
            }
            --this.size;
            return value;
        }
        this.balanceNodesAfterRemove(treePath, temp);
        --this.size;
        return value;
    }

    private void balanceNodesAfterRemove(List<LinkedAvlMapNode<K, V>> treePath, LinkedAvlMapNode<K, V> delNode) {
        LinkedAvlMapNode y = null;
        this.removeFromList(delNode);
        if (delNode.isLeaf()) {
            if (!treePath.isEmpty()) {
                this.detachNodes(delNode, treePath.get(0));
            }
        } else if (delNode.left != null) {
            List leftTreePath = this.findMax(delNode.left);
            y = leftTreePath.remove(0);
            if (leftTreePath.isEmpty()) {
                this.detachNodes(y, delNode);
            } else {
                this.detachNodes(y, leftTreePath.remove(0));
            }
            leftTreePath.addAll(treePath);
            treePath = leftTreePath;
            y.right = delNode.right;
            if (delNode == this.root) {
                y.left = delNode.left;
                this.root = y;
            } else {
                this.replaceNode(delNode, y, treePath.get(0));
            }
        } else if (delNode.right != null) {
            List rightTreePath = this.findMin(delNode.right);
            y = rightTreePath.remove(0);
            if (rightTreePath.isEmpty()) {
                this.detachNodes(y, delNode);
            } else {
                this.detachNodes(y, rightTreePath.remove(0));
            }
            rightTreePath.addAll(treePath);
            treePath = rightTreePath;
            y.right = delNode.right;
            if (delNode == this.root) {
                y.right = delNode.right;
                this.root = y;
            } else {
                this.replaceNode(delNode, y, treePath.get(0));
            }
        }
        treePath.add(0, y);
        this.balance(treePath);
    }

    private void balance(List<LinkedAvlMapNode<K, V>> treePath) {
        LinkedAvlMapNode<K, V> parentNode = null;
        int size = treePath.size();
        for (LinkedAvlMapNode<K, V> node : treePath) {
            int balFactor = this.getBalance(node);
            if (node != this.root && treePath.indexOf(node) < size - 1) {
                parentNode = treePath.get(treePath.indexOf(node) + 1);
            }
            if (balFactor > 1) {
                if (this.getBalance(node.right) <= -1) {
                    this.rotateSingleRight(node.right, node);
                    this.rotateSingleLeft(node, parentNode);
                    continue;
                }
                this.rotateSingleLeft(node, parentNode);
                continue;
            }
            if (balFactor >= -1) continue;
            if (this.getBalance(node.left) >= 1) {
                this.rotateSingleLeft(node.left, node);
                this.rotateSingleRight(node, parentNode);
                continue;
            }
            this.rotateSingleRight(node, parentNode);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    void setRoot(LinkedAvlMapNode<K, V> root) {
        this.root = root;
    }

    void setFirst(LinkedAvlMapNode<K, V> first) {
        this.first = first;
    }

    void setLast(LinkedAvlMapNode<K, V> last) {
        this.last = last;
    }

    @Override
    public LinkedAvlMapNode<K, V> getRoot() {
        return this.root;
    }

    @Override
    public List<K> getKeys() {
        ArrayList keys = new ArrayList();
        LinkedAvlMapNode<K, V> node = this.first;
        while (node != null) {
            keys.add(node.key);
            node = node.next;
        }
        return keys;
    }

    @Override
    public void printTree() {
        if (this.isEmpty()) {
            System.out.println("Tree is empty");
            return;
        }
        this.getRoot().setDepth(0);
        System.out.println(this.getRoot());
        this.visit(this.getRoot().getRight(), this.getRoot());
        this.visit(this.getRoot().getLeft(), this.getRoot());
    }

    @Override
    public LinkedAvlMapNode<K, V> getFirst() {
        return this.first;
    }

    @Override
    public LinkedAvlMapNode<K, V> getLast() {
        return this.last;
    }

    private void rotateSingleLeft(LinkedAvlMapNode<K, V> node, LinkedAvlMapNode<K, V> parentNode) {
        LinkedAvlMapNode temp = node.right;
        node.right = temp.left;
        temp.left = node;
        if (node == this.root) {
            this.root = temp;
        } else if (parentNode != null) {
            if (parentNode.left == node) {
                parentNode.left = temp;
            } else if (parentNode.right == node) {
                parentNode.right = temp;
            }
        }
    }

    private void rotateSingleRight(LinkedAvlMapNode<K, V> node, LinkedAvlMapNode<K, V> parentNode) {
        LinkedAvlMapNode temp = node.left;
        node.left = temp.right;
        temp.right = node;
        if (node == this.root) {
            this.root = temp;
        } else if (parentNode != null) {
            if (parentNode.left == node) {
                parentNode.left = temp;
            } else if (parentNode.right == node) {
                parentNode.right = temp;
            }
        } else if (this.root != null && this.root.left == node) {
            this.root.left = temp;
        }
    }

    private void detachNodes(LinkedAvlMapNode<K, V> node, LinkedAvlMapNode<K, V> parentNode) {
        if (parentNode != null) {
            if (node == parentNode.left) {
                parentNode.left = node.left;
            } else if (node == parentNode.right) {
                parentNode.right = node.left;
            }
        }
    }

    private void replaceNode(LinkedAvlMapNode<K, V> deleteNode, LinkedAvlMapNode<K, V> replaceNode, LinkedAvlMapNode<K, V> parentNode) {
        if (parentNode != null) {
            replaceNode.left = deleteNode.left;
            if (deleteNode == parentNode.left) {
                parentNode.left = replaceNode;
            } else if (deleteNode == parentNode.right) {
                parentNode.right = replaceNode;
            }
        }
    }

    private List<LinkedAvlMapNode<K, V>> find(K key, LinkedAvlMapNode<K, V> startNode, List<LinkedAvlMapNode<K, V>> path) {
        if (startNode == null) {
            return null;
        }
        path.add(0, startNode);
        int c = this.keyComparator.compare(key, startNode.key);
        if (c == 0) {
            return path;
        }
        if (c > 0) {
            return this.find(key, startNode.right, path);
        }
        if (c < 0) {
            return this.find(key, startNode.left, path);
        }
        return null;
    }

    @Override
    public LinkedAvlMapNode<K, V> findGreater(K key) {
        LinkedAvlMapNode<K, V> result = this.fetchNonNullNode(key, this.root, this.root);
        if (result == null) {
            return null;
        }
        if (this.keyComparator.compare(key, result.key) < 0) {
            return result;
        }
        return result.next;
    }

    @Override
    public LinkedAvlMapNode<K, V> findGreaterOrEqual(K key) {
        LinkedAvlMapNode<K, V> result = this.fetchNonNullNode(key, this.root, this.root);
        if (result == null) {
            return null;
        }
        if (this.keyComparator.compare(key, result.key) <= 0) {
            return result;
        }
        return result.next;
    }

    @Override
    public LinkedAvlMapNode<K, V> findLess(K key) {
        LinkedAvlMapNode<K, V> result = this.fetchNonNullNode(key, this.root, this.root);
        if (result == null) {
            return null;
        }
        if (this.keyComparator.compare(key, result.key) > 0) {
            return result;
        }
        return result.previous;
    }

    @Override
    public LinkedAvlMapNode<K, V> findLessOrEqual(K key) {
        LinkedAvlMapNode<K, V> result = this.fetchNonNullNode(key, this.root, this.root);
        if (result == null) {
            return null;
        }
        if (this.keyComparator.compare(key, result.key) >= 0) {
            return result;
        }
        return result.previous;
    }

    private LinkedAvlMapNode<K, V> fetchNonNullNode(K key, LinkedAvlMapNode<K, V> startNode, LinkedAvlMapNode<K, V> parent) {
        if (startNode == null) {
            return parent;
        }
        int c = this.keyComparator.compare(key, startNode.key);
        parent = startNode;
        if (c > 0) {
            return this.fetchNonNullNode(key, startNode.right, parent);
        }
        if (c < 0) {
            return this.fetchNonNullNode(key, startNode.left, parent);
        }
        return startNode;
    }

    @Override
    public LinkedAvlMapNode<K, V> find(K key) {
        return this.find(key, this.root);
    }

    @Override
    public LinkedAvlMapNode<K, V> find(K key, V value) {
        AvlTree dupsTree;
        if (key == null || value == null) {
            return null;
        }
        LinkedAvlMapNode<K, V> node = this.find(key, this.root);
        if (node == null) {
            return null;
        }
        if (node.value.isOrderedSet() ? (dupsTree = node.value.getOrderedSet()).find(value) == null : this.valueComparator.compare(node.value.getSingleton(), value) != 0) {
            return null;
        }
        return node;
    }

    @Override
    private LinkedAvlMapNode<K, V> find(K key, LinkedAvlMapNode<K, V> startNode) {
        if (startNode == null) {
            return null;
        }
        int c = this.keyComparator.compare(key, startNode.key);
        if (c > 0) {
            startNode.isLeft = false;
            return this.find(key, startNode.right);
        }
        if (c < 0) {
            startNode.isLeft = true;
            return this.find(key, startNode.left);
        }
        return startNode;
    }

    private List<LinkedAvlMapNode<K, V>> findMax(LinkedAvlMapNode<K, V> startNode) {
        LinkedAvlMapNode<K, V> x = startNode;
        LinkedAvlMapNode<K, V> y = null;
        if (x == null) {
            return null;
        }
        while (x.right != null) {
            x.isLeft = false;
            y = x;
            x = x.right;
        }
        ArrayList<LinkedAvlMapNode<K, V>> path = new ArrayList<LinkedAvlMapNode<K, V>>(2);
        path.add(x);
        if (y != null) {
            path.add(y);
        }
        return path;
    }

    private List<LinkedAvlMapNode<K, V>> findMin(LinkedAvlMapNode<K, V> startNode) {
        LinkedAvlMapNode<K, V> x = startNode;
        LinkedAvlMapNode<K, V> y = null;
        if (x == null) {
            return null;
        }
        while (x.left != null) {
            x.isLeft = true;
            y = x;
            x = x.left;
        }
        ArrayList<LinkedAvlMapNode<K, V>> path = new ArrayList<LinkedAvlMapNode<K, V>>(2);
        path.add(x);
        if (y != null) {
            path.add(y);
        }
        return path;
    }

    private int getBalance(LinkedAvlMapNode<K, V> node) {
        if (node == null) {
            return 0;
        }
        return node.getBalance();
    }

    private void visit(LinkedAvlMapNode<K, V> node, LinkedAvlMapNode<K, V> parentNode) {
        if (node == null) {
            return;
        }
        if (!node.isLeaf()) {
            node.setDepth(parentNode.getDepth() + 1);
        }
        for (int i = 0; i < parentNode.getDepth(); ++i) {
            System.out.print("|  ");
        }
        String type = "";
        if (node == parentNode.left) {
            type = "L";
        } else if (node == parentNode.right) {
            type = "R";
        }
        System.out.println("|--" + node + type);
        if (node.getRight() != null) {
            this.visit(node.getRight(), node);
        }
        if (node.getLeft() != null) {
            this.visit(node.getLeft(), node);
        }
    }

    @Override
    public boolean isDupsAllowed() {
        return this.allowDuplicates;
    }
}

