/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.internal.InternalModifyDnRequest;
import org.apache.directory.shared.ldap.name.DN;

public class MoveOperationContext
extends AbstractChangeOperationContext {
    private DN parent;

    public MoveOperationContext(CoreSession session) {
        super(session);
    }

    public MoveOperationContext(CoreSession session, DN oldDn, DN parent) {
        super(session, oldDn);
        this.parent = parent;
    }

    public MoveOperationContext(CoreSession session, InternalModifyDnRequest modifyDnRequest) {
        super(session, modifyDnRequest.getName());
        this.parent = modifyDnRequest.getNewSuperior();
        if (this.parent == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_326, modifyDnRequest));
        }
        this.requestControls = modifyDnRequest.getControls();
        if (modifyDnRequest.getNewRdn() != null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_327, modifyDnRequest));
        }
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    public DN getParent() {
        return this.parent;
    }

    public void setParent(DN parent) {
        this.parent = parent;
    }

    public String getName() {
        return MessageTypeEnum.MODIFYDN_REQUEST.name();
    }

    public String toString() {
        return "ReplaceContext for old DN '" + this.getDn().getName() + "'" + ", parent '" + this.parent + "'";
    }
}

