/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Iterator;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.ldap.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.cursor.CursorIterator;
import org.apache.directory.shared.ldap.entry.ServerEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEntryCursorAdaptor<ID>
implements Cursor<ServerEntry> {
    private final BTreePartition<ID> db;
    private final IndexCursor<ID, ServerEntry, ID> indexCursor;

    public ServerEntryCursorAdaptor(BTreePartition<ID> db, IndexCursor<ID, ServerEntry, ID> indexCursor) {
        this.db = db;
        this.indexCursor = indexCursor;
    }

    @Override
    public void after(ServerEntry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws Exception {
        this.indexCursor.afterLast();
    }

    @Override
    public boolean available() {
        return this.indexCursor.available();
    }

    @Override
    public void before(ServerEntry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws Exception {
        this.indexCursor.beforeFirst();
    }

    @Override
    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.indexCursor.setClosureMonitor(monitor);
    }

    @Override
    public void close() throws Exception {
        this.indexCursor.close();
    }

    @Override
    public void close(Exception e) throws Exception {
        this.indexCursor.close(e);
    }

    @Override
    public boolean first() throws Exception {
        return this.indexCursor.first();
    }

    @Override
    public ServerEntry get() throws Exception {
        IndexEntry indexEntry = (IndexEntry)this.indexCursor.get();
        if (indexEntry.getObject() == null) {
            indexEntry.setObject(this.db.lookup(indexEntry.getId()));
        }
        return (ServerEntry)indexEntry.getObject();
    }

    @Override
    public boolean isClosed() throws Exception {
        return this.indexCursor.isClosed();
    }

    @Override
    public boolean isElementReused() {
        return this.indexCursor.isElementReused();
    }

    @Override
    public boolean last() throws Exception {
        return this.indexCursor.last();
    }

    @Override
    public boolean next() throws Exception {
        return this.indexCursor.next();
    }

    @Override
    public boolean previous() throws Exception {
        return this.indexCursor.previous();
    }

    @Override
    public Iterator<ServerEntry> iterator() {
        return new CursorIterator<ServerEntry>(this);
    }
}

