/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.sp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.DN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(LdapClassLoader.class);
    public static String defaultSearchContextsConfig = "cn=classLoaderDefaultSearchContext,ou=configuration,ou=system";
    private DN defaultSearchDn;
    private DirectoryService directoryService;

    public LdapClassLoader(DirectoryService directoryService) throws LdapException {
        super(LdapClassLoader.class.getClassLoader());
        this.directoryService = directoryService;
        this.defaultSearchDn = new DN(defaultSearchContextsConfig);
        this.defaultSearchDn.normalize(directoryService.getSchemaManager().getNormalizerMapping());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] findClassInDIT(List<DN> searchContexts, String name) throws ClassNotFoundException {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>("fullyQualifiedJavaClassName", new StringValue(name)));
        filter.addNode(new EqualityNode<String>("objectClass", new StringValue("javaClass")));
        try {
            Iterator<DN> i$ = searchContexts.iterator();
            while (i$.hasNext()) {
                DN base = i$.next();
                Cursor cursor = null;
                try {
                    cursor = this.directoryService.getAdminSession().search(base, SearchScope.SUBTREE, filter, AliasDerefMode.DEREF_ALWAYS, null);
                    cursor.beforeFirst();
                    if (!cursor.next()) continue;
                    log.debug("Class {} found under {} search context.", (Object)name, (Object)base);
                    ServerEntry classEntry = (ServerEntry)cursor.get();
                    if (cursor.next()) {
                        ServerEntry other = (ServerEntry)cursor.get();
                        log.warn("More than one class found on classpath at locations: {} \n\tand {}", classEntry, (Object)other);
                    }
                    byte[] byArray = classEntry.get("javaClassByteCode").getBytes();
                    return byArray;
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
            throw new ClassNotFoundException();
        }
        catch (Exception e) {
            log.error(I18n.err(I18n.ERR_69, name), e);
        }
        throw new ClassNotFoundException();
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = null;
        try {
            DN dn;
            ClonedServerEntry configEntry = null;
            try {
                configEntry = this.directoryService.getAdminSession().lookup(this.defaultSearchDn);
            }
            catch (LdapException e) {
                log.debug("No configuration data found for class loader default search contexts.");
            }
            if (configEntry != null) {
                ArrayList<DN> searchContexts = new ArrayList<DN>();
                EntryAttribute attr = configEntry.get("classLoaderDefaultSearchContext");
                for (Value val : attr) {
                    dn = new DN(val.getString());
                    dn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
                    searchContexts.add(dn);
                }
                try {
                    classBytes = this.findClassInDIT(searchContexts, name);
                    log.debug("Class " + name + " found under default search contexts.");
                }
                catch (ClassNotFoundException e) {
                    log.debug("Class " + name + " could not be found under default search contexts.");
                }
            }
            if (classBytes == null) {
                ArrayList<DN> namingContexts = new ArrayList<DN>();
                Set<String> suffixes = this.directoryService.getPartitionNexus().listSuffixes(new ListSuffixOperationContext(this.directoryService.getAdminSession()));
                for (String suffix : suffixes) {
                    dn = new DN(suffix);
                    dn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
                    namingContexts.add(dn);
                }
                classBytes = this.findClassInDIT(namingContexts, name);
            }
        }
        catch (ClassNotFoundException e) {
            String msg = I18n.err(I18n.ERR_293, name);
            log.debug(msg);
            throw new ClassNotFoundException(msg);
        }
        catch (Exception e) {
            String msg = I18n.err(I18n.ERR_70, name);
            log.error(msg, e);
            throw new ClassNotFoundException(msg);
        }
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }
}

