/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.sp;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.sp.StoredProcEngine;
import org.apache.directory.server.core.sp.StoredProcEngineConfig;
import org.apache.directory.server.core.sp.StoredProcUtils;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.constants.SchemaConstants;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcExecutionManager {
    private static final Set<AttributeTypeOptions> EMPTY_ATTRIBS = Collections.emptySet();
    private final String storedProcContainer;
    private final List<StoredProcEngineConfig> storedProcEngineConfigs;

    public StoredProcExecutionManager(String storedProcContainer, List<StoredProcEngineConfig> storedProcEngineConfigs) {
        this.storedProcContainer = storedProcContainer;
        this.storedProcEngineConfigs = storedProcEngineConfigs;
    }

    public ClonedServerEntry findStoredProcUnit(CoreSession session, String fullSPName) throws Exception {
        SearchControls controls = new SearchControls();
        controls.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        controls.setSearchScope(2);
        String spUnitName = StoredProcUtils.extractStoredProcUnitName(fullSPName);
        AttributeType at = session.getDirectoryService().getSchemaManager().lookupAttributeTypeRegistry("storedProcUnitName");
        EqualityNode<String> filter = new EqualityNode<String>("storedProcUnitName", new StringValue(at, spUnitName));
        DN dn = new DN(this.storedProcContainer);
        EntryFilteringCursor results = session.search(dn, SearchScope.SUBTREE, filter, AliasDerefMode.DEREF_ALWAYS, EMPTY_ATTRIBS);
        if (results.first()) {
            ClonedServerEntry entry = (ClonedServerEntry)results.get();
            results.close();
            return entry;
        }
        return null;
    }

    public StoredProcEngine getStoredProcEngineInstance(ClonedServerEntry spUnitEntry) throws LdapException {
        String spLangId = spUnitEntry.getOriginalEntry().get("storedProcLangId").getString();
        for (StoredProcEngineConfig engineConfig : this.storedProcEngineConfigs) {
            StoredProcEngine engine;
            if (!engineConfig.getStoredProcLangId().equalsIgnoreCase(spLangId)) continue;
            Class<? extends StoredProcEngine> engineType = engineConfig.getStoredProcEngineType();
            try {
                engine = engineType.newInstance();
            }
            catch (InstantiationException e) {
                LdapException ne = new LdapException(e.getMessage());
                ne.initCause(e);
                throw ne;
            }
            catch (IllegalAccessException e) {
                LdapException ne = new LdapException(e.getMessage());
                ne.initCause(e);
                throw ne;
            }
            engine.setSPUnitEntry(spUnitEntry.getOriginalEntry());
            return engine;
        }
        throw new LdapException(I18n.err(I18n.ERR_294, spLangId));
    }
}

