/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncryptionKeyDecoder {
    public static EncryptionKey decode(byte[] encodedEncryptionKey) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedEncryptionKey);
        DERSequence sequence = (DERSequence)ais.readObject();
        return EncryptionKeyDecoder.decode(sequence);
    }

    protected static EncryptionKey decode(DERSequence sequence) {
        EncryptionType type = EncryptionType.NULL;
        byte[] data = null;
        Enumeration<DEREncodable> e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    type = EncryptionType.getTypeByOrdinal(tag0.intValue());
                    break;
                }
                case 1: {
                    DEROctetString tag1 = (DEROctetString)derObject;
                    data = tag1.getOctets();
                }
            }
        }
        return new EncryptionKey(type, data);
    }
}

