/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.directory.server.kerberos.shared.io.encoder.AuthorizationDataEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.ChecksumEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.Encoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncoderFactory;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionKeyEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class AuthenticatorEncoder
implements Encoder,
EncoderFactory {
    private static final int APPLICATION_CODE = 2;

    public byte[] encode(Encodable authenticator) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        DERSequence replySequence = this.encodeInitialSequence((Authenticator)authenticator);
        aos.writeObject(DERApplicationSpecific.valueOf(2, replySequence));
        aos.close();
        return baos.toByteArray();
    }

    public Encoder getEncoder() {
        return new AuthenticatorEncoder();
    }

    private DERSequence encodeInitialSequence(Authenticator authenticator) {
        String clientRealm = authenticator.getClientPrincipal().getRealm();
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(0, DERInteger.valueOf(authenticator.getVersionNumber())));
        sequence.add(new DERTaggedObject(1, DERGeneralString.valueOf(clientRealm)));
        sequence.add(new DERTaggedObject(2, PrincipalNameEncoder.encode(authenticator.getClientPrincipal())));
        if (authenticator.getChecksum() != null) {
            sequence.add(new DERTaggedObject(3, ChecksumEncoder.encode(authenticator.getChecksum())));
        }
        sequence.add(new DERTaggedObject(4, DERInteger.valueOf(authenticator.getClientMicroSecond())));
        sequence.add(new DERTaggedObject(5, KerberosTimeEncoder.encode(authenticator.getClientTime())));
        if (authenticator.getSubSessionKey() != null) {
            sequence.add(new DERTaggedObject(6, EncryptionKeyEncoder.encodeSequence(authenticator.getSubSessionKey())));
        }
        if (authenticator.getSequenceNumber() > 0) {
            sequence.add(new DERTaggedObject(7, DERInteger.valueOf(authenticator.getSequenceNumber())));
        }
        if (authenticator.getAuthorizationData() != null) {
            sequence.add(new DERTaggedObject(8, AuthorizationDataEncoder.encode(authenticator.getAuthorizationData())));
        }
        return sequence;
    }
}

