/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAttributeDescFilterAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(InitAttributeDescFilterAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public InitAttributeDescFilterAction() {
        super("Initialize AttributeDesc filter");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        AttributeValueAssertion assertion = new AttributeValueAssertion();
        if (tlv.getLength() == 0) {
            log.error(I18n.err("ERR_04007", new Object[0]));
            throw new DecoderException(I18n.err("ERR_04007", new Object[0]));
        }
        String type = StringTools.utf8ToString(tlv.getValue().getData());
        assertion.setAttributeDesc(type);
        AttributeValueAssertionFilter terminalFilter = (AttributeValueAssertionFilter)searchRequest.getTerminalFilter();
        terminalFilter.setAssertion(assertion);
        if (IS_DEBUG) {
            log.debug("Initialize AttributeDesc filter");
        }
    }
}

