/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.AbstractPoolableLdapConnectionFactory;
import org.apache.directory.ldap.client.api.DefaultLdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.ValidatingPoolableLdapConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnectionPool
extends GenericObjectPool<LdapConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(LdapConnectionPool.class);
    private PoolableObjectFactory<LdapConnection> factory;

    public LdapConnectionPool(LdapConnectionConfig connectionConfig, LdapApiService apiService, long timeout) {
        this(connectionConfig, apiService, timeout, null);
    }

    public LdapConnectionPool(LdapConnectionConfig connectionConfig, LdapApiService apiService, long timeout, GenericObjectPool.Config poolConfig) {
        this(LdapConnectionPool.newPoolableConnectionFactory(connectionConfig, apiService, timeout), poolConfig);
    }

    public LdapConnectionPool(PoolableObjectFactory<LdapConnection> factory) {
        this(factory, (GenericObjectPool.Config)null);
    }

    public LdapConnectionPool(PoolableObjectFactory<LdapConnection> factory, GenericObjectPool.Config poolConfig) {
        super(factory, poolConfig == null ? new GenericObjectPool.Config() : poolConfig);
        this.factory = factory;
    }

    public LdapApiService getLdapApiService() {
        return ((AbstractPoolableLdapConnectionFactory)this.factory).getLdapApiService();
    }

    public LdapConnection getConnection() throws LdapException {
        LdapConnection connection;
        try {
            connection = (LdapConnection)super.borrowObject();
            LOG.trace("borrowed connection {}", (Object)connection);
        }
        catch (RuntimeException | LdapException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("An unexpected exception was thrown: ", e);
            throw new RuntimeException(e);
        }
        return connection;
    }

    private static ValidatingPoolableLdapConnectionFactory newPoolableConnectionFactory(LdapConnectionConfig connectionConfig, LdapApiService apiService, long timeout) {
        DefaultLdapConnectionFactory connectionFactory = new DefaultLdapConnectionFactory(connectionConfig);
        connectionFactory.setLdapApiService(apiService);
        connectionFactory.setTimeOut(timeout);
        return new ValidatingPoolableLdapConnectionFactory(connectionFactory);
    }

    public void releaseConnection(LdapConnection connection) throws LdapException {
        try {
            super.returnObject(connection);
            LOG.trace("returned connection {}", (Object)connection);
        }
        catch (RuntimeException | LdapException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("An unexpected exception was thrown: ", e);
            throw new RuntimeException(e);
        }
    }
}

