/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.entry;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.comparators.StringComparator;
import org.apache.directory.api.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.directory.api.util.Serialize;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Value
implements Cloneable,
Externalizable,
Comparable<Value> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(Value.class);
    private transient AttributeType attributeType;
    private String upValue;
    private String normValue;
    private volatile int h;
    private byte[] bytes;
    private boolean isHR = true;
    private static StringComparator stringComparator = new StringComparator(null);

    public Value(String upValue) {
        this.upValue = upValue;
        this.normValue = upValue;
        if (upValue != null) {
            this.bytes = Strings.getBytesUtf8(upValue);
        }
        this.hashCode();
    }

    public Value(byte[] value) {
        if (value != null) {
            this.bytes = new byte[value.length];
            System.arraycopy(value, 0, this.bytes, 0, value.length);
        } else {
            this.bytes = null;
        }
        this.isHR = false;
        this.hashCode();
    }

    public Value(AttributeType attributeType, byte[] upValue) throws LdapInvalidAttributeValueException {
        this.init(attributeType);
        if (upValue != null) {
            this.bytes = new byte[upValue.length];
            System.arraycopy(upValue, 0, this.bytes, 0, upValue.length);
            if (this.isHR) {
                this.upValue = Strings.utf8ToString(upValue);
            }
        } else {
            this.bytes = null;
        }
        if (attributeType != null && !attributeType.isRelaxed()) {
            SyntaxChecker syntaxChecker = attributeType.getSyntax().getSyntaxChecker();
            if (syntaxChecker != null) {
                if (!syntaxChecker.isValidSyntax(this.bytes)) {
                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13246_INVALID_VALUE_PER_SYNTAX, new Object[0]));
                }
            } else {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13219_NULL_SYNTAX_CHECKER, this.normValue));
            }
        }
        this.hashCode();
    }

    private void init(AttributeType attributeType) {
        if (attributeType != null) {
            if (attributeType.getSyntax() == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(I18n.err(I18n.ERR_13225_NO_SYNTAX, new Object[0]));
                }
                this.isHR = true;
            } else {
                this.isHR = attributeType.getSyntax().isHumanReadable();
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn(I18n.msg(I18n.MSG_13202_AT_IS_NULL, new Object[0]));
        }
        this.attributeType = attributeType;
    }

    Value(AttributeType attributeType) {
        this.init(attributeType);
    }

    public Value(AttributeType attributeType, String upValue) throws LdapInvalidAttributeValueException {
        this.init(attributeType);
        this.upValue = upValue;
        this.bytes = (byte[])(upValue != null ? Strings.getBytesUtf8(upValue) : null);
        try {
            this.computeNormValue();
        }
        catch (LdapException le) {
            LOG.error(le.getMessage());
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13247_INVALID_VALUE_CANT_NORMALIZE, new Object[0]));
        }
        if (!attributeType.isRelaxed()) {
            LdapSyntax syntax = attributeType.getSyntax();
            if (syntax != null && syntax.getSyntaxChecker() != null) {
                if (!attributeType.getSyntax().getSyntaxChecker().isValidSyntax(upValue)) {
                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13246_INVALID_VALUE_PER_SYNTAX, new Object[0]));
                }
            } else {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13219_NULL_SYNTAX_CHECKER, this.normValue));
            }
        }
        this.hashCode();
    }

    public Value(AttributeType attributeType, String upValue, String normValue) throws LdapInvalidAttributeValueException {
        this.init(attributeType);
        this.upValue = upValue;
        this.bytes = (byte[])(upValue != null ? Strings.getBytesUtf8(upValue) : null);
        this.normValue = normValue;
        if (!attributeType.isRelaxed()) {
            if (attributeType.getSyntax().getSyntaxChecker() != null) {
                if (!attributeType.getSyntax().getSyntaxChecker().isValidSyntax(upValue)) {
                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13246_INVALID_VALUE_PER_SYNTAX, new Object[0]));
                }
            } else {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13219_NULL_SYNTAX_CHECKER, normValue));
            }
        }
        this.hashCode();
    }

    public Value(AttributeType attributeType, Value value) throws LdapInvalidAttributeValueException {
        this.init(attributeType);
        if (this.isHR) {
            this.upValue = value.isHR ? value.upValue : Strings.utf8ToString(value.bytes);
        }
        try {
            this.computeNormValue();
        }
        catch (LdapException le) {
            LOG.error(le.getMessage());
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13247_INVALID_VALUE_CANT_NORMALIZE, new Object[0]));
        }
        if (!attributeType.isRelaxed()) {
            if (attributeType.getSyntax().getSyntaxChecker() != null) {
                attributeType.getSyntax().getSyntaxChecker().isValidSyntax(value.normValue);
            } else {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13219_NULL_SYNTAX_CHECKER, this.normValue));
            }
        }
        if (value.bytes != null) {
            this.bytes = new byte[value.bytes.length];
            System.arraycopy(value.bytes, 0, this.bytes, 0, value.bytes.length);
        }
        this.hashCode();
    }

    public static Value createValue(AttributeType attributeType) {
        return new Value(attributeType);
    }

    public Value clone() {
        try {
            Value clone = (Value)super.clone();
            if (this.isHR) {
                return clone;
            }
            if (this.bytes != null) {
                clone.bytes = new byte[this.bytes.length];
                System.arraycopy(this.bytes, 0, clone.bytes, 0, this.bytes.length);
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean isNull() {
        if (this.isHR) {
            return this.upValue == null;
        }
        return this.bytes == null;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public boolean isInstanceOf(AttributeType attributeType) {
        return attributeType != null && (this.attributeType.equals(attributeType) || this.attributeType.isDescendantOf(attributeType));
    }

    public String getEscaped() {
        if (Strings.isEmpty(this.bytes)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean leadChar = true;
        for (int pos = 0; pos < this.bytes.length; ++pos) {
            boolean trailChar = pos == this.bytes.length - 1;
            byte b = this.bytes[pos];
            switch (b) {
                case 0: {
                    sb.append("\\00");
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    sb.append((char)b);
                    break;
                }
                case 32: {
                    if (leadChar || trailChar) {
                        sb.append("\\ ");
                        break;
                    }
                    sb.append((char)b);
                    break;
                }
                case 33: {
                    sb.append((char)b);
                    break;
                }
                case 34: {
                    sb.append("\\\"");
                    break;
                }
                case 35: {
                    if (leadChar) {
                        sb.append("\\#");
                        break;
                    }
                    sb.append('#');
                    break;
                }
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    sb.append((char)b);
                    break;
                }
                case 43: {
                    sb.append("\\+");
                    break;
                }
                case 44: {
                    sb.append("\\,");
                    break;
                }
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    sb.append((char)b);
                    break;
                }
                case 59: {
                    sb.append("\\;");
                    break;
                }
                case 60: {
                    sb.append("\\<");
                    break;
                }
                case 61: {
                    sb.append((char)b);
                    break;
                }
                case 62: {
                    sb.append("\\>");
                    break;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: {
                    sb.append((char)b);
                    break;
                }
                case 92: {
                    sb.append("\\\\");
                    break;
                }
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    sb.append((char)b);
                    break;
                }
                case -128: 
                case -127: 
                case -126: 
                case -125: 
                case -124: 
                case -123: 
                case -122: 
                case -121: 
                case -120: 
                case -119: 
                case -118: 
                case -117: 
                case -116: 
                case -115: 
                case -114: 
                case -113: 
                case -112: 
                case -111: 
                case -110: 
                case -109: 
                case -108: 
                case -107: 
                case -106: 
                case -105: 
                case -104: 
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: 
                case -89: 
                case -88: 
                case -87: 
                case -86: 
                case -85: 
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: 
                case -78: 
                case -77: 
                case -76: 
                case -75: 
                case -74: 
                case -73: 
                case -72: 
                case -71: 
                case -70: 
                case -69: 
                case -68: 
                case -67: 
                case -66: 
                case -65: 
                case -64: 
                case -63: {
                    sb.append('\\').append(Strings.byteToString(b));
                    break;
                }
                case -62: 
                case -61: 
                case -60: 
                case -59: 
                case -58: 
                case -57: 
                case -56: 
                case -55: 
                case -54: 
                case -53: 
                case -52: 
                case -51: 
                case -50: 
                case -49: 
                case -48: 
                case -47: 
                case -46: 
                case -45: 
                case -44: 
                case -43: 
                case -42: 
                case -41: 
                case -40: 
                case -39: 
                case -38: 
                case -37: 
                case -36: 
                case -35: 
                case -34: 
                case -33: {
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = this.bytes[pos + 1] & 0xFF;
                    if (b2 >= 128 && b2 <= 191) {
                        sb.append(Strings.utf8ToString(this.bytes, pos, 2));
                        ++pos;
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    break;
                }
                case -32: {
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == this.bytes.length - 2) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = this.bytes[pos + 1] & 0xFF;
                    if (b2 >= 160 && b2 <= 191) {
                        b3 = this.bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            sb.append(Strings.utf8ToString(this.bytes, pos, 3));
                            pos += 2;
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    break;
                }
                case -31: 
                case -30: 
                case -29: 
                case -28: 
                case -27: 
                case -26: 
                case -25: 
                case -24: 
                case -23: 
                case -22: 
                case -21: 
                case -20: 
                case -18: 
                case -17: {
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == this.bytes.length - 2) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = this.bytes[pos + 1] & 0xFF;
                    if (b2 >= 128 && b2 <= 191) {
                        b3 = this.bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            sb.append(Strings.utf8ToString(this.bytes, pos, 3));
                            pos += 2;
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    ++pos;
                    break;
                }
                case -19: {
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == this.bytes.length - 2) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = this.bytes[pos + 1] & 0xFF;
                    if (b2 >= 128 && b2 <= 159) {
                        b3 = this.bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            sb.append(Strings.utf8ToString(this.bytes, pos, 3));
                            pos += 2;
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    ++pos;
                    break;
                }
                case -16: {
                    int b4;
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == this.bytes.length - 3) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = this.bytes[pos + 1] & 0xFF;
                    if (b2 >= 144 && b2 <= 191) {
                        b3 = this.bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            b4 = this.bytes[pos + 3] & 0xFF;
                            if (b4 >= 128 && b4 <= 191) {
                                sb.append(Strings.utf8ToString(this.bytes, pos, 4));
                                pos += 3;
                                break;
                            }
                            sb.append('\\').append(Strings.byteToString(b));
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    ++pos;
                    break;
                }
                case -15: 
                case -14: 
                case -13: {
                    int b4;
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == this.bytes.length - 3) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = this.bytes[pos + 1] & 0xFF;
                    if (b2 >= 128 && b2 <= 191) {
                        b3 = this.bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            b4 = this.bytes[pos + 3] & 0xFF;
                            if (b4 >= 128 && b4 <= 191) {
                                sb.append(Strings.utf8ToString(this.bytes, pos, 4));
                                pos += 3;
                                break;
                            }
                            sb.append('\\').append(Strings.byteToString(b));
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    ++pos;
                    break;
                }
                case -12: {
                    int b4;
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == this.bytes.length - 3) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = this.bytes[pos + 1] & 0xFF;
                    if (b2 >= 128 && b2 <= 143) {
                        b3 = this.bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            b4 = this.bytes[pos + 3] & 0xFF;
                            if (b4 >= 128 && b4 <= 191) {
                                sb.append(Strings.utf8ToString(this.bytes, pos, 4));
                                pos += 3;
                                break;
                            }
                            sb.append('\\').append(Strings.byteToString(b));
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    ++pos;
                    break;
                }
                default: {
                    sb.append('\\').append(Strings.byteToString(b));
                }
            }
            if (!leadChar) continue;
            leadChar = false;
        }
        return sb.toString();
    }

    public String getString() {
        if (this.isHR) {
            return this.upValue;
        }
        return Strings.utf8ToString(this.bytes);
    }

    private void computeNormValue() throws LdapException {
        MatchingRule ordering;
        MatchingRule subString;
        if (this.upValue == null) {
            return;
        }
        MatchingRule equality = this.attributeType.getEquality();
        Normalizer normalizer = equality == null ? ((subString = this.attributeType.getSubstring()) == null ? ((ordering = this.attributeType.getOrdering()) == null ? new NoOpNormalizer() : ordering.getNormalizer()) : subString.getNormalizer()) : equality.getNormalizer();
        if (normalizer == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13220_NO_NORMALIZER, new Object[0]));
        }
        this.normValue = normalizer.normalize(this.upValue);
    }

    public String getNormalized() {
        return this.normValue;
    }

    public String getUpValue() {
        if (this.isHR) {
            return this.upValue;
        }
        return this.getEscaped();
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            return null;
        }
        if (this.bytes.length == 0) {
            return Strings.EMPTY_BYTES;
        }
        byte[] copy = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
        return copy;
    }

    public boolean isSchemaAware() {
        return this.attributeType != null;
    }

    public final boolean isValid(SyntaxChecker syntaxChecker) throws LdapInvalidAttributeValueException {
        if (syntaxChecker == null) {
            String message = I18n.err(I18n.ERR_13219_NULL_SYNTAX_CHECKER, this.toString());
            LOG.error(message);
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (this.isHR) {
            return syntaxChecker.isValidSyntax(this.getString());
        }
        return syntaxChecker.isValidSyntax(this.bytes);
    }

    public boolean isHumanReadable() {
        return this.isHR;
    }

    public int length() {
        if (this.isHR) {
            return this.upValue != null ? this.upValue.length() : 0;
        }
        return this.bytes != null ? this.bytes.length : 0;
    }

    private LdapComparator<?> getLdapComparator() {
        MatchingRule mr;
        if (this.attributeType != null && (mr = this.attributeType.getEquality()) != null) {
            return mr.getLdapComparator();
        }
        return null;
    }

    public int serialize(byte[] buffer, int pos) {
        int length = 1;
        byte[] preparedBytes = null;
        if (this.isHR) {
            if (this.upValue != null) {
                length += 5 + this.bytes.length;
            }
            if (this.normValue != null) {
                preparedBytes = Strings.getBytesUtf8(this.normValue);
                length += 5 + preparedBytes.length;
            }
        } else {
            length = this.bytes != null ? 6 + this.bytes.length : 2;
        }
        if (buffer.length - pos < length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.isHR) {
            buffer[pos++] = 1;
            if (this.bytes != null) {
                buffer[pos++] = 1;
                pos = Serialize.serialize(this.bytes, buffer, pos);
            } else {
                buffer[pos++] = 0;
            }
            if (this.normValue != null) {
                buffer[pos++] = 1;
                pos = Serialize.serialize(preparedBytes, buffer, pos);
            } else {
                buffer[pos++] = 0;
            }
        } else {
            buffer[pos++] = 0;
            if (this.bytes != null) {
                buffer[pos++] = 1;
                pos = Serialize.serialize(this.bytes, buffer, pos);
            } else {
                buffer[pos++] = 0;
            }
        }
        return pos;
    }

    public static Value deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        Value value = new Value((AttributeType)null);
        value.readExternal(in);
        return value;
    }

    public static Value deserialize(AttributeType attributeType, ObjectInput in) throws IOException, ClassNotFoundException {
        Value value = new Value(attributeType);
        value.readExternal(in);
        return value;
    }

    public int deserialize(byte[] buffer, int pos) throws IOException, LdapInvalidAttributeValueException {
        if (pos < 0 || pos >= buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.isHR = Serialize.deserializeBoolean(buffer, pos);
        ++pos;
        if (this.isHR) {
            boolean hasValue = Serialize.deserializeBoolean(buffer, pos);
            ++pos;
            if (hasValue) {
                this.bytes = Serialize.deserializeBytes(buffer, pos);
                pos += 4 + this.bytes.length;
                this.upValue = Strings.utf8ToString(this.bytes);
            }
            boolean hasPreparedValue = Serialize.deserializeBoolean(buffer, pos);
            ++pos;
            if (hasPreparedValue) {
                byte[] preparedBytes = Serialize.deserializeBytes(buffer, pos);
                pos += 4 + preparedBytes.length;
                this.normValue = Strings.utf8ToString(preparedBytes);
            }
        } else {
            boolean hasBytes = Serialize.deserializeBoolean(buffer, pos);
            ++pos;
            if (hasBytes) {
                this.bytes = Serialize.deserializeBytes(buffer, pos);
                pos += 4 + this.bytes.length;
            }
        }
        if (this.attributeType != null) {
            try {
                this.computeNormValue();
            }
            catch (LdapException le) {
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, le.getMessage());
            }
        }
        this.hashCode();
        return pos;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.isHR = in.readBoolean();
        if (this.isHR) {
            if (in.readBoolean()) {
                int length = in.readInt();
                this.bytes = new byte[length];
                if (length != 0) {
                    in.readFully(this.bytes);
                }
                this.upValue = Strings.utf8ToString(this.bytes);
            }
            if (in.readBoolean()) {
                this.normValue = in.readUTF();
            }
        } else if (in.readBoolean()) {
            int length = in.readInt();
            this.bytes = new byte[length];
            if (length != 0) {
                in.readFully(this.bytes);
            }
        }
        this.hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.isHR);
        if (this.isHR) {
            out.writeBoolean(this.upValue != null);
            if (this.upValue != null) {
                out.writeInt(this.bytes.length);
                if (this.bytes.length > 0) {
                    out.write(this.bytes);
                }
            }
            out.writeBoolean(this.normValue != null);
            if (this.normValue != null) {
                out.writeUTF(this.normValue);
            }
        } else {
            out.writeBoolean(this.bytes != null);
            if (this.bytes != null) {
                out.writeInt(this.bytes.length);
                if (this.bytes.length > 0) {
                    out.write(this.bytes);
                }
            }
        }
        out.flush();
    }

    @Override
    public int compareTo(String other) {
        if (!this.isHR) {
            String msg = I18n.err(I18n.ERR_13224_FAILED_TO_COMPARE_NORM_VALUES, this, other);
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        if (this.bytes == null) {
            if (other == null) {
                return 0;
            }
            return -1;
        }
        if (other == null) {
            return 1;
        }
        try {
            if (this.attributeType != null) {
                String normalizedOther = this.attributeType.getEquality().getNormalizer().normalize(other);
                return this.normValue.compareTo(normalizedOther);
            }
            return this.normValue.compareTo(other);
        }
        catch (LdapException le) {
            return -1;
        }
    }

    @Override
    public int compareTo(byte[] other) {
        if (this.isHR) {
            String msg = I18n.err(I18n.ERR_13224_FAILED_TO_COMPARE_NORM_VALUES, this, other);
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        if (this.bytes == null) {
            if (other == null) {
                return 0;
            }
            return -1;
        }
        if (other == null) {
            return 1;
        }
        return Strings.compare(this.bytes, other);
    }

    @Override
    public int compareTo(Value other) {
        if (this.isHR != other.isHR) {
            String msg = I18n.err(I18n.ERR_13224_FAILED_TO_COMPARE_NORM_VALUES, this, other);
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        if (this.bytes == null) {
            if (other.bytes == null) {
                return 0;
            }
            return -1;
        }
        if (other.bytes == null) {
            return 1;
        }
        if (!this.isHR) {
            return Strings.compare(this.bytes, other.bytes);
        }
        try {
            if (this.attributeType != null) {
                if (other.attributeType == null) {
                    String normalizedOther = this.attributeType.getEquality().getNormalizer().normalize(other.upValue);
                    return this.normValue.compareTo(normalizedOther);
                }
                return this.normValue.compareTo(other.normValue);
            }
            if (other.attributeType != null) {
                String normalizedThis = other.attributeType.getEquality().getNormalizer().normalize(this.upValue);
                return normalizedThis.compareTo(other.normValue);
            }
            return this.normValue.compareTo(other.normValue);
        }
        catch (LdapException le) {
            return -1;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof String) {
            String other = (String)obj;
            if (!this.isHR) {
                return false;
            }
            if (this.attributeType == null) {
                if (this.upValue != null) {
                    return this.upValue.equals(other);
                }
                return obj == null;
            }
            try {
                LdapComparator<?> comparator = this.getLdapComparator();
                Normalizer normalizer = null;
                if (this.attributeType.getEquality() != null) {
                    normalizer = this.attributeType.getEquality().getNormalizer();
                }
                if (normalizer == null) {
                    if (comparator == null) {
                        return this.normValue.equals(other);
                    }
                    return comparator.compare(this.normValue, other) == 0;
                }
                String thisNormValue = this.normValue;
                String otherNormValue = normalizer.normalize(other);
                if (comparator == null) {
                    return thisNormValue.equals(otherNormValue);
                }
                return comparator.compare(thisNormValue, otherNormValue) == 0;
            }
            catch (LdapException ne) {
                return false;
            }
        }
        if (!(obj instanceof Value)) {
            return false;
        }
        Value other = (Value)obj;
        if (this.isHR != other.isHR) {
            return false;
        }
        if (!this.isHR) {
            return Arrays.equals(this.bytes, other.bytes);
        }
        if (this.bytes == null) {
            return other.bytes == null;
        }
        if (other.bytes == null) {
            return false;
        }
        if (this.bytes.length == 0) {
            return other.bytes.length == 0;
        }
        if (other.bytes.length == 0) {
            return false;
        }
        if (this.attributeType == null) {
            if (other.attributeType != null) {
                MatchingRule equalityMR = other.attributeType.getEquality();
                if (equalityMR == null) {
                    return Arrays.equals(this.bytes, other.bytes);
                }
                LdapComparator<? super Object> ldapComparator = equalityMR.getLdapComparator();
                if (ldapComparator == null) {
                    LOG.error(I18n.err(I18n.ERR_13249_NO_COMPARATOR_FOR_AT, other.attributeType));
                    return false;
                }
                return ldapComparator.compare(this.normValue, other.normValue) == 0;
            }
            if (this.upValue != null) {
                return this.upValue.equals(other.upValue);
            }
            return Arrays.equals(this.bytes, other.bytes);
        }
        if (other.attributeType != null) {
            if (!this.attributeType.equals(other.attributeType)) {
                return false;
            }
            LdapComparator<?> comparator = this.getLdapComparator();
            if (other.attributeType.getEquality() == null) {
                return stringComparator.compare(this.normValue, other.normValue) == 0;
            }
            if (comparator == null) {
                return this.normValue.equals(other.normValue);
            }
            return comparator.compare(this.normValue, other.normValue) == 0;
        }
        if (this.normValue == null) {
            return other.normValue == null;
        }
        return this.normValue.equals(other.normValue);
    }

    public int hashCode() {
        if (this.h == 0) {
            this.h = this.isHR ? (this.normValue != null ? this.normValue.hashCode() : 0) : Arrays.hashCode(this.bytes);
        }
        return this.h;
    }

    public String toString() {
        if (this.isHR) {
            return this.upValue == null ? "null" : this.upValue;
        }
        if (this.bytes == null) {
            return "null";
        }
        if (this.bytes.length > 16) {
            byte[] copy = new byte[16];
            System.arraycopy(this.bytes, 0, copy, 0, 16);
            return Strings.dumpBytes(copy) + "...";
        }
        return Strings.dumpBytes(this.bytes);
    }
}

