/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.security.CertificateUtil;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.LdapServer;
import sun.security.x509.X500Name;

public abstract class AbstractLdapTestUnit {
    public static DirectoryService service;
    public static LdapServer ldapServer;
    public static KdcServer kdcServer;

    public static DirectoryService getService() {
        return service;
    }

    public static void setService(DirectoryService service) {
        AbstractLdapTestUnit.service = service;
    }

    public static LdapServer getLdapServer() {
        return ldapServer;
    }

    public static void setLdapServer(LdapServer ldapServer) {
        AbstractLdapTestUnit.ldapServer = ldapServer;
    }

    public static KdcServer getKdcServer() {
        return kdcServer;
    }

    public static void setKdcServer(KdcServer kdcServer) {
        AbstractLdapTestUnit.kdcServer = kdcServer;
    }

    public void changeCertificate(String keyStoreFile, String password, String issuerDn, String subjectDn, int days, String algorithm) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] keyStorePassword = password.toCharArray();
        try (FileInputStream keyStoreData = new FileInputStream(keyStoreFile);){
            keyStore.load(null, keyStorePassword);
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X500Name subject = new X500Name(subjectDn, "directory", "apache", "US");
        X500Name issuer = new X500Name(issuerDn, "directory", "apache", "US");
        X509Certificate certificate = CertificateUtil.generateCertificate(subject, issuer, keyPair, days, algorithm);
        keyStore.setKeyEntry("apachedsKey", keyPair.getPrivate(), keyStorePassword, new X509Certificate[]{certificate});
        try (FileOutputStream out = new FileOutputStream(keyStoreFile);){
            keyStore.store(out, keyStorePassword);
        }
    }
}

