/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.replay;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.time.Duration;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayCacheImpl
implements ReplayCache {
    private static final Logger LOG = LoggerFactory.getLogger(ReplayCacheImpl.class);
    Cache<String, Object> cache;
    private static final long DEFAULT_CLOCK_SKEW = 300000L;
    private long clockSkew = 300000L;

    public ReplayCacheImpl(long clockSkew) {
        this.clockSkew = clockSkew;
        this.cache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(clockSkew)).build();
    }

    @Override
    public synchronized boolean isReplay(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
        ReplayCacheEntry entry = new ReplayCacheEntry(serverPrincipal, clientPrincipal, clientTime, clientMicroSeconds);
        ReplayCacheEntry found = (ReplayCacheEntry)this.cache.getIfPresent(entry.createKey());
        if (found == null) {
            return false;
        }
        entry = found;
        return serverPrincipal.equals(entry.serverPrincipal) && clientTime.equals(entry.clientTime) && clientMicroSeconds == entry.clientMicroSeconds;
    }

    @Override
    public synchronized void save(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
        ReplayCacheEntry entry = new ReplayCacheEntry(serverPrincipal, clientPrincipal, clientTime, clientMicroSeconds);
        this.cache.put(entry.createKey(), entry);
    }

    @Override
    public void clear() {
        LOG.debug("removing all the elements from cache");
        this.cache.invalidateAll();
    }

    public static class ReplayCacheEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private KerberosPrincipal serverPrincipal;
        private KerberosPrincipal clientPrincipal;
        private KerberosTime clientTime;
        private int clientMicroSeconds;

        public ReplayCacheEntry(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
            this.serverPrincipal = serverPrincipal;
            this.clientPrincipal = clientPrincipal;
            this.clientTime = clientTime;
            this.clientMicroSeconds = clientMicroSeconds;
        }

        public boolean equals(ReplayCacheEntry that) {
            return this.serverPrincipal.equals(that.serverPrincipal) && this.clientPrincipal.equals(that.clientPrincipal) && this.clientTime.equals(that.clientTime) && this.clientMicroSeconds == that.clientMicroSeconds;
        }

        public boolean isOutsideClockSkew(long clockSkew) {
            return !this.clientTime.isInClockSkew(clockSkew);
        }

        private String createKey() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.clientPrincipal == null ? "null" : this.clientPrincipal.getName());
            sb.append('#');
            sb.append(this.serverPrincipal == null ? "null" : this.serverPrincipal.getName());
            sb.append('#');
            sb.append(this.clientTime == null ? "null" : this.clientTime.getDate());
            sb.append('#');
            sb.append(this.clientMicroSeconds);
            return sb.toString();
        }
    }
}

