/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdbm.RecordManager;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmMasterTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmRdnIndex;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractStore;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.Tuple;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.exception.MultiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmStore<E>
extends AbstractStore<E, Long> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmStore.class);
    private RecordManager recMan;
    private static final String JDBM_DB_FILE_EXTN = ".db";
    private static final FilenameFilter DB_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(JdbmStore.JDBM_DB_FILE_EXTN) && !name.startsWith("master.");
        }
    };

    public Long getDefaultId() {
        return 1L;
    }

    protected Long getRootId() {
        return 0L;
    }

    public synchronized void init(SchemaManager schemaManager) throws Exception {
        super.init(schemaManager);
        this.getPartitionDir().mkdirs();
        String path = this.getPartitionDir().getPath() + File.separator + "master";
        BaseRecordManager base = new BaseRecordManager(path);
        base.disableTransactions();
        if (this.cacheSize < 0) {
            this.cacheSize = 10000;
            LOG.debug("Using the default entry cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
        } else {
            LOG.debug("Using the custom configured cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
        }
        this.recMan = new CacheRecordManager((RecordManager)base, (CachePolicy)new MRU(this.cacheSize));
        this.master = new JdbmMasterTable(this.recMan, schemaManager);
        File[] allIndexDbFiles = this.getPartitionDir().listFiles(DB_FILTER);
        List<String> indexDbFileNameList = Arrays.asList(this.getPartitionDir().list(DB_FILTER));
        this.setupSystemIndices();
        this.setupUserIndices();
        ArrayList<String> allIndices = new ArrayList<String>();
        for (Index i : this.systemIndices.values()) {
            allIndices.add(i.getAttribute().getOid());
        }
        for (Index i : this.userIndices.values()) {
            allIndices.add(i.getAttribute().getOid());
            String name = i.getAttribute().getOid() + JDBM_DB_FILE_EXTN;
            if (indexDbFileNameList.contains(name)) continue;
            this.buildUserIndex(i);
        }
        this.deleteUnusedIndexFiles(allIndices, allIndexDbFiles);
        this.initialized = true;
    }

    public synchronized void destroy() throws Exception {
        LOG.debug("destroy() called on store for {}", (Object)this.suffixDn);
        if (!this.initialized) {
            return;
        }
        ArrayList array = new ArrayList();
        array.addAll(this.userIndices.values());
        array.addAll(this.systemIndices.values());
        MultiException errors = new MultiException(I18n.err((I18n)I18n.ERR_577, (Object[])new Object[0]));
        for (Index index : array) {
            try {
                index.close();
                LOG.debug("Closed {} index for {} partition.", (Object)index.getAttributeId(), (Object)this.suffixDn);
            }
            catch (Throwable t) {
                LOG.error(I18n.err((I18n)I18n.ERR_124, (Object[])new Object[0]), t);
                errors.addThrowable(t);
            }
        }
        try {
            this.master.close();
            LOG.debug(I18n.err((I18n)I18n.ERR_125, (Object[])new Object[]{this.suffixDn}));
        }
        catch (Throwable t) {
            LOG.error(I18n.err((I18n)I18n.ERR_126, (Object[])new Object[0]), t);
            errors.addThrowable(t);
        }
        try {
            this.recMan.close();
            LOG.debug("Closed record manager for {} partition.", (Object)this.suffixDn);
        }
        catch (Throwable t) {
            LOG.error(I18n.err((I18n)I18n.ERR_127, (Object[])new Object[0]), t);
            errors.addThrowable(t);
        }
        if (errors.size() > 0) {
            throw errors;
        }
        this.initialized = false;
    }

    public synchronized void sync() throws Exception {
        if (!this.initialized) {
            return;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        array.addAll(this.userIndices.values());
        array.add(this.aliasIdx);
        array.add(this.oneAliasIdx);
        array.add(this.subAliasIdx);
        array.add(this.oneLevelIdx);
        array.add(this.presenceIdx);
        array.add(this.subLevelIdx);
        array.add(this.entryCsnIdx);
        array.add(this.entryUuidIdx);
        array.add(this.objectClassIdx);
        for (Index index : array) {
            index.sync();
        }
        this.rdnIdx.sync();
        ((JdbmMasterTable)this.master).sync();
        this.recMan.commit();
    }

    protected Index<?, E, Long> convertAndInit(Index<?, E, Long> index) throws Exception {
        JdbmIndex jdbmIndex;
        if (index.getAttributeId().equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
            jdbmIndex = new JdbmRdnIndex();
            jdbmIndex.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.50");
            jdbmIndex.setCacheSize(index.getCacheSize());
            jdbmIndex.setNumDupLimit(512);
            jdbmIndex.setWkDirPath(index.getWkDirPath());
        } else if (index instanceof JdbmIndex) {
            jdbmIndex = (JdbmIndex)index;
            if (jdbmIndex.getWkDirPath() == null) {
                jdbmIndex.setWkDirPath(this.partitionPath);
            }
        } else {
            LOG.debug("Supplied index {} is not a JdbmIndex.  Will create new JdbmIndex using copied configuration parameters.", index);
            jdbmIndex = new JdbmIndex(index.getAttributeId());
            jdbmIndex.setCacheSize(index.getCacheSize());
            jdbmIndex.setNumDupLimit(512);
            jdbmIndex.setWkDirPath(index.getWkDirPath());
        }
        jdbmIndex.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId()));
        return jdbmIndex;
    }

    private void deleteUnusedIndexFiles(List<String> allIndices, File[] dbFiles) {
        for (File file : dbFiles) {
            String name = file.getName();
            if (allIndices.contains(name = name.substring(0, name.lastIndexOf(JDBM_DB_FILE_EXTN)))) continue;
            boolean deleted = file.delete();
            if (deleted) {
                LOG.info("Deleted unused index file {}", (Object)file.getAbsolutePath());
                try {
                    String atName = this.schemaManager.lookupAttributeTypeRegistry(name).getName();
                    File txtFile = new File(file.getParent(), name + "-" + atName + ".txt");
                    deleted = txtFile.delete();
                    if (deleted) continue;
                    LOG.info("couldn't delete the index name helper file {}", (Object)txtFile);
                }
                catch (Exception e) {
                    LOG.warn("couldn't find the attribute's name with oid {}", (Object)name);
                    LOG.warn("", (Throwable)e);
                }
                continue;
            }
            LOG.warn("Failed to delete unused index file {}", (Object)file.getAbsolutePath());
        }
    }

    private File getPartitionDir() {
        return new File(this.getPartitionPath());
    }

    public void buildUserIndex(Index userIdx) throws Exception {
        AttributeType atType = userIdx.getAttribute();
        LOG.info("building the index for attribute type {}", (Object)atType);
        Cursor cursor = this.master.cursor();
        cursor.beforeFirst();
        String attributeOid = userIdx.getAttribute().getOid();
        while (cursor.next()) {
            Tuple tuple = (Tuple)cursor.get();
            Long id = (Long)tuple.getKey();
            Entry entry = (Entry)tuple.getValue();
            Attribute entryAttr = entry.get(atType);
            if (entryAttr == null) continue;
            for (Value value : entryAttr) {
                userIdx.add(value.getValue(), (Object)id);
            }
            this.presenceIdx.add((Object)attributeOid, (Object)id);
        }
        cursor.close();
    }
}

