/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.keytab;

import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.mina.core.buffer.IoBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeytabEncoder {
    KeytabEncoder() {
    }

    IoBuffer write(byte[] keytabVersion, List<KeytabEntry> entries) {
        IoBuffer buffer = IoBuffer.allocate((int)512);
        this.putKeytabVersion(buffer, keytabVersion);
        this.putKeytabEntries(buffer, entries);
        buffer.flip();
        return buffer;
    }

    private void putKeytabVersion(IoBuffer buffer, byte[] version) {
        buffer.put(version);
    }

    private void putKeytabEntries(IoBuffer buffer, List<KeytabEntry> entries) {
        Iterator<KeytabEntry> iterator = entries.iterator();
        while (iterator.hasNext()) {
            IoBuffer entryBuffer = this.putKeytabEntry(iterator.next());
            int size = entryBuffer.position();
            entryBuffer.flip();
            buffer.putInt(size);
            buffer.put(entryBuffer);
        }
    }

    private IoBuffer putKeytabEntry(KeytabEntry entry) {
        IoBuffer buffer = IoBuffer.allocate((int)100);
        this.putPrincipalName(buffer, entry.getPrincipalName());
        buffer.putInt((int)entry.getPrincipalType());
        buffer.putInt((int)(entry.getTimeStamp().getTime() / 1000L));
        buffer.put(entry.getKeyVersion());
        this.putKeyBlock(buffer, entry.getKey());
        return buffer;
    }

    private void putPrincipalName(IoBuffer buffer, String principalName) {
        String[] split = principalName.split("@");
        String nameComponent = split[0];
        String realm = split[1];
        String[] nameComponents = nameComponent.split("/");
        buffer.putShort((short)nameComponents.length);
        this.putCountedString(buffer, realm);
        for (int ii = 0; ii < nameComponents.length; ++ii) {
            this.putCountedString(buffer, nameComponents[ii]);
        }
    }

    private void putKeyBlock(IoBuffer buffer, EncryptionKey key) {
        buffer.putShort((short)key.getKeyType().getValue());
        this.putCountedBytes(buffer, key.getKeyValue());
    }

    private void putCountedString(IoBuffer buffer, String string) {
        byte[] data = string.getBytes();
        buffer.putShort((short)data.length);
        buffer.put(data);
    }

    private void putCountedBytes(IoBuffer buffer, byte[] data) {
        buffer.putShort((short)data.length);
        buffer.put(data);
    }
}

