/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.etypeInfoEntry.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.etypeInfoEntry.ETypeInfoEntryContainer;
import org.apache.directory.shared.kerberos.components.ETypeInfoEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETypeInfoEntryInit
extends GrammarAction<ETypeInfoEntryContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(ETypeInfoEntryInit.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public ETypeInfoEntryInit() {
        super("Creates a ETYPE-INFO-ENTRY instance");
    }

    public void action(ETypeInfoEntryContainer eTypeInfoEntryContainer) throws DecoderException {
        TLV tlv = eTypeInfoEntryContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        ETypeInfoEntry etypeInfoEntry = new ETypeInfoEntry();
        eTypeInfoEntryContainer.setETypeInfoEntry(etypeInfoEntry);
        if (IS_DEBUG) {
            LOG.debug("ETYPE-INFO-ENTRY created");
        }
    }
}

