/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.krbSafe.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.krbSafe.KrbSafeContainer;
import org.apache.directory.shared.kerberos.codec.krbSafeBody.KrbSafeBodyContainer;
import org.apache.directory.shared.kerberos.components.KrbSafeBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreSafeBody
extends GrammarAction<KrbSafeContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSafeBody.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreSafeBody() {
        super("KRB-SAFE safe-body");
    }

    public void action(KrbSafeContainer krbSafeContainer) throws DecoderException {
        TLV tlv = krbSafeContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        Asn1Decoder krbSafeBodyDecoder = new Asn1Decoder();
        KrbSafeBodyContainer krbSafeBodyContainer = new KrbSafeBodyContainer();
        krbSafeBodyContainer.setStream(krbSafeContainer.getStream());
        krbSafeBodyDecoder.decode(krbSafeContainer.getStream(), (Asn1Container)krbSafeBodyContainer);
        KrbSafeBody krbSafeBody = krbSafeBodyContainer.getKrbSafeBody();
        if (IS_DEBUG) {
            LOG.debug("KrbSafeBody : {}", (Object)krbSafeBody);
        }
        krbSafeContainer.getKrbSafe().setSafeBody(krbSafeBody);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        krbSafeContainer.updateParent();
    }
}

