/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.store;

import java.net.InetAddress;
import java.util.Map;
import org.apache.directory.server.dhcp.DhcpException;
import org.apache.directory.server.dhcp.messages.HardwareAddress;
import org.apache.directory.server.dhcp.options.OptionsField;
import org.apache.directory.server.dhcp.options.vendor.HostName;
import org.apache.directory.server.dhcp.options.vendor.SubnetMask;
import org.apache.directory.server.dhcp.service.Lease;
import org.apache.directory.server.dhcp.store.DhcpConfigElement;
import org.apache.directory.server.dhcp.store.DhcpStore;
import org.apache.directory.server.dhcp.store.Host;
import org.apache.directory.server.dhcp.store.Subnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDhcpStore
implements DhcpStore {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDhcpStore.class);

    public Lease getLeaseOffer(HardwareAddress hardwareAddress, InetAddress requestedAddress, InetAddress selectionBase, long requestedLeaseTime, OptionsField options) throws DhcpException {
        Subnet subnet = this.findSubnet(selectionBase);
        if (null == subnet) {
            logger.warn("Don't know anything about the sbnet containing " + selectionBase);
            return null;
        }
        Lease lease = null;
        if (null != (lease = this.findExistingLease(hardwareAddress, lease))) {
            return lease;
        }
        Host host = null;
        host = this.findDesignatedHost(hardwareAddress);
        if (null != host) {
            if (!subnet.contains(host.getAddress())) {
                logger.warn("Host " + host + " is not within the subnet for which an address is requested");
            } else {
                Map properties = this.getProperties(subnet);
                properties.putAll(this.getProperties(host));
                lease = new Lease();
                lease.setAcquired(System.currentTimeMillis());
                long leaseTime = this.determineLeaseTime(requestedLeaseTime, properties);
                lease.setExpires(System.currentTimeMillis() + leaseTime);
                lease.setHardwareAddress(hardwareAddress);
                lease.setState(1);
                lease.setClientAddress(host.getAddress());
                OptionsField o = lease.getOptions();
                o.add(new HostName(host.getName()));
                o.add(new SubnetMask(subnet.getNetmask()));
                o.merge(subnet.getOptions());
                o.merge(host.getOptions());
            }
        }
        if (null == lease) {
            // empty if block
        }
        if (null != lease && lease.getState() != 3) {
            lease.setState(2);
            this.updateLease(lease);
        }
        return lease;
    }

    public Lease getExistingLease(HardwareAddress hardwareAddress, InetAddress requestedAddress, InetAddress selectionBase, long requestedLeaseTime, OptionsField options) throws DhcpException {
        Lease lease = null;
        if (null == (lease = this.findExistingLease(hardwareAddress, lease))) {
            return null;
        }
        if (!lease.getClientAddress().equals(requestedAddress)) {
            logger.warn("Requested address " + requestedAddress + " for " + hardwareAddress + " doesn't match existing lease " + lease);
            return null;
        }
        Subnet subnet = this.findSubnet(selectionBase);
        if (null == subnet) {
            logger.warn("No subnet found for existing lease " + lease);
            return null;
        }
        if (!subnet.contains(lease.getClientAddress())) {
            logger.warn("Client with existing lease " + lease + " is on wrong subnet " + subnet);
            return null;
        }
        if (!subnet.isInRange(lease.getClientAddress())) {
            logger.warn("Client with existing lease " + lease + " is out of valid range for subnet " + subnet);
            return null;
        }
        Map properties = this.getProperties(subnet);
        OptionsField o = lease.getOptions();
        o.clear();
        o.add(new SubnetMask(subnet.getNetmask()));
        o.merge(subnet.getOptions());
        Host host = this.findDesignatedHost(hardwareAddress);
        if (null != host) {
            if (host.getAddress() != null && !host.getAddress().equals(lease.getClientAddress())) {
                logger.warn("Existing fixed address for " + hardwareAddress + " conflicts with existing lease " + lease);
                return null;
            }
            properties.putAll(this.getProperties(host));
            o.add(new HostName(host.getName()));
            o.merge(host.getOptions());
        }
        long leaseTime = this.determineLeaseTime(requestedLeaseTime, properties);
        lease.setExpires(System.currentTimeMillis() + leaseTime);
        lease.setHardwareAddress(hardwareAddress);
        if (lease.getState() != 3) {
            lease.setState(3);
            this.updateLease(lease);
        }
        this.updateLease(lease);
        return lease;
    }

    private long determineLeaseTime(long requestedLeaseTime, Map properties) {
        long leaseTime = 3600000L;
        Integer propMaxLeaseTime = (Integer)properties.get("max-lease-time");
        if (null != propMaxLeaseTime) {
            leaseTime = requestedLeaseTime > 0L ? Math.min((long)propMaxLeaseTime.intValue() * 1000L, requestedLeaseTime) : (long)propMaxLeaseTime.intValue() * 1000L;
        }
        return leaseTime;
    }

    public void releaseLease(Lease lease) {
        lease.setState(4);
        this.updateLease(lease);
    }

    protected abstract void updateLease(Lease var1);

    protected abstract OptionsField getOptions(DhcpConfigElement var1);

    protected abstract Map getProperties(DhcpConfigElement var1);

    protected abstract Lease findExistingLease(HardwareAddress var1, Lease var2);

    protected abstract Host findDesignatedHost(HardwareAddress var1) throws DhcpException;

    protected abstract Subnet findSubnet(InetAddress var1);
}

