/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.xdbm;

import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapAuthenticationNotSupportedException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXdbmPartition<ID extends Comparable<ID>>
extends BTreePartition<ID> {
    protected boolean optimizerEnabled = true;
    protected Store<Entry, ID> store;

    protected AbstractXdbmPartition(Store<Entry, ID> store) {
        this.store = store;
    }

    protected void doDestroy() throws Exception {
        this.store.destroy();
    }

    public final boolean isInitialized() {
        return this.store.isInitialized();
    }

    @Override
    public final void sync() throws Exception {
        this.store.sync();
    }

    public boolean isOptimizerEnabled() {
        return this.optimizerEnabled;
    }

    public void setOptimizerEnabled(boolean optimizerEnabled) {
        this.optimizerEnabled = optimizerEnabled;
    }

    public void setSyncOnWrite(boolean syncOnWrite) {
        this.store.setSyncOnWrite(syncOnWrite);
    }

    public boolean isSyncOnWrite() {
        return this.store.isSyncOnWrite();
    }

    @Override
    public final void addIndexOn(Index<?, Entry, ID> index) throws Exception {
        this.store.addIndex(index);
    }

    @Override
    public final Index<ID, Entry, ID> getOneLevelIndex() {
        return this.store.getOneLevelIndex();
    }

    @Override
    public final Index<String, Entry, ID> getAliasIndex() {
        return this.store.getAliasIndex();
    }

    @Override
    public final Index<ID, Entry, ID> getOneAliasIndex() {
        return this.store.getOneAliasIndex();
    }

    @Override
    public final Index<ID, Entry, ID> getSubAliasIndex() {
        return this.store.getSubAliasIndex();
    }

    @Override
    public final Iterator<String> getUserIndices() {
        return this.store.userIndices();
    }

    @Override
    public final Iterator<String> getSystemIndices() {
        return this.store.systemIndices();
    }

    @Override
    public final boolean hasUserIndexOn(AttributeType attributeType) throws Exception {
        return this.store.hasUserIndexOn(attributeType);
    }

    @Override
    public final boolean hasSystemIndexOn(AttributeType attributeType) throws Exception {
        return this.store.hasSystemIndexOn(attributeType);
    }

    @Override
    public final Index<?, Entry, ID> getUserIndex(AttributeType attributeType) throws IndexNotFoundException {
        return this.store.getUserIndex(attributeType);
    }

    @Override
    public final Index<?, Entry, ID> getSystemIndex(AttributeType attributeType) throws IndexNotFoundException {
        return this.store.getSystemIndex(attributeType);
    }

    @Override
    public final ID getEntryId(Dn dn) throws LdapException {
        try {
            return this.store.getEntryId(dn);
        }
        catch (Exception e) {
            throw new LdapException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final Dn getEntryDn(ID id) throws Exception {
        return this.store.getEntryDn(id);
    }

    @Override
    public final int count() throws Exception {
        return this.store.count();
    }

    @Override
    public final void add(AddOperationContext addContext) throws LdapException {
        try {
            this.store.add(((ClonedServerEntry)addContext.getEntry()).getClonedEntry());
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    @Override
    public final ClonedServerEntry lookup(ID id) throws LdapException {
        try {
            return new ClonedServerEntry(this.store.lookup(id));
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final void delete(ID id) throws LdapException {
        try {
            this.store.delete(id);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final IndexCursor<ID, Entry, ID> list(ID id) throws LdapException {
        try {
            return this.store.list(id);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final int getChildCount(ID id) throws LdapException {
        try {
            return this.store.getChildCount(id);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final void setProperty(String propertyName, String propertyValue) throws Exception {
        this.store.setProperty(propertyName, propertyValue);
    }

    @Override
    public final String getProperty(String propertyName) throws Exception {
        return this.store.getProperty(propertyName);
    }

    @Override
    public final void modify(ModifyOperationContext modifyContext) throws LdapException {
        try {
            Entry modifiedEntry = this.store.modify(modifyContext.getDn(), modifyContext.getModItems());
            modifyContext.setAlteredEntry(modifiedEntry);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final void rename(RenameOperationContext renameContext) throws LdapException {
        try {
            Dn oldDn = renameContext.getDn();
            Rdn newRdn = renameContext.getNewRdn();
            boolean deleteOldRdn = renameContext.getDeleteOldRdn();
            if (renameContext.getEntry() != null) {
                Entry modifiedEntry = renameContext.getModifiedEntry();
                this.store.rename(oldDn, newRdn, deleteOldRdn, modifiedEntry);
            } else {
                this.store.rename(oldDn, newRdn, deleteOldRdn);
            }
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (moveAndRenameContext.getNewSuperiorDn().isDescendantOf(moveAndRenameContext.getDn())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "cannot place an entry below itself");
        }
        try {
            Dn oldDn = moveAndRenameContext.getDn();
            Dn newSuperiorDn = moveAndRenameContext.getNewSuperiorDn();
            Rdn newRdn = moveAndRenameContext.getNewRdn();
            boolean deleteOldRdn = moveAndRenameContext.getDeleteOldRdn();
            Entry modifiedEntry = moveAndRenameContext.getModifiedEntry();
            this.store.moveAndRename(oldDn, newSuperiorDn, newRdn, modifiedEntry, deleteOldRdn);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final void move(MoveOperationContext moveContext) throws LdapException {
        if (moveContext.getNewSuperior().isDescendantOf(moveContext.getDn())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "cannot place an entry below itself");
        }
        try {
            Dn oldDn = moveContext.getDn();
            Dn newSuperior = moveContext.getNewSuperior();
            Dn newDn = moveContext.getNewDn();
            Entry modifiedEntry = moveContext.getModifiedEntry();
            this.store.move(oldDn, newSuperior, newDn, modifiedEntry);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public final void bind(Dn bindDn, byte[] credentials, List<String> mechanisms, String saslAuthId) throws LdapException {
        throw new LdapAuthenticationNotSupportedException(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED, I18n.err((I18n)I18n.ERR_702, (Object[])new Object[0]));
    }

    public final void bind(BindOperationContext bindContext) throws LdapException {
        throw new LdapAuthenticationNotSupportedException(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED, I18n.err((I18n)I18n.ERR_702, (Object[])new Object[0]));
    }

    public final void unbind(UnbindOperationContext unbindContext) throws LdapException {
    }

    @Override
    public final Index<String, Entry, ID> getPresenceIndex() {
        return this.store.getPresenceIndex();
    }

    @Override
    public final Index<ID, Entry, ID> getSubLevelIndex() {
        return this.store.getSubLevelIndex();
    }

    public String toString() {
        return "Partition<" + this.id + ">";
    }
}

