/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.GenericIndex;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.MasterTable;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.asn1.util.Oid;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapAliasDereferencingException;
import org.apache.directory.shared.ldap.model.exception.LdapAliasException;
import org.apache.directory.shared.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStore<E, ID extends Comparable<ID>>
implements Store<E, ID> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStore.class);
    public static final int DEFAULT_CACHE_SIZE = 10000;
    protected AttributeType OBJECT_CLASS_AT;
    protected AttributeType ENTRY_CSN_AT;
    protected AttributeType ENTRY_UUID_AT;
    protected AttributeType ALIASED_OBJECT_NAME_AT;
    protected boolean initialized;
    protected URI partitionPath;
    protected AtomicBoolean isSyncOnWrite = new AtomicBoolean(true);
    protected int cacheSize = 10000;
    protected String id;
    protected Dn suffixDn;
    protected SchemaManager schemaManager;
    protected MasterTable<ID, Entry> master;
    protected Map<String, Index<?, E, ID>> userIndices = new HashMap();
    protected Map<String, Index<?, E, ID>> systemIndices = new HashMap();
    protected Index<String, E, ID> presenceIdx;
    protected Index<ID, E, ID> subLevelIdx;
    protected Index<ID, E, ID> oneLevelIdx;
    protected Index<String, E, ID> aliasIdx;
    protected Index<ID, E, ID> oneAliasIdx;
    protected Index<ID, E, ID> subAliasIdx;
    protected Index<String, E, ID> objectClassIdx;
    protected Index<String, E, ID> entryUuidIdx;
    protected Index<String, E, ID> entryCsnIdx;
    protected Index<ParentIdAndRdn<ID>, E, ID> rdnIdx;
    private boolean checkHasEntryDuringAdd = false;

    @Override
    public void init(SchemaManager schemaManager) throws Exception {
        this.schemaManager = schemaManager;
        this.OBJECT_CLASS_AT = schemaManager.getAttributeType("objectClass");
        this.ALIASED_OBJECT_NAME_AT = schemaManager.getAttributeType("aliasedObjectName");
        this.ENTRY_CSN_AT = schemaManager.getAttributeType("entryCSN");
        this.ENTRY_UUID_AT = schemaManager.getAttributeType("entryUUID");
    }

    protected void protect(String property) {
        if (this.initialized) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_576, (Object[])new Object[]{property}));
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setPartitionPath(URI partitionPath) {
        this.protect("partitionPath");
        this.partitionPath = partitionPath;
    }

    @Override
    public URI getPartitionPath() {
        return this.partitionPath;
    }

    @Override
    public void setSyncOnWrite(boolean isSyncOnWrite) {
        this.protect("syncOnWrite");
        this.isSyncOnWrite.set(isSyncOnWrite);
    }

    @Override
    public boolean isSyncOnWrite() {
        return this.isSyncOnWrite.get();
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.protect("cacheSize");
        this.cacheSize = cacheSize;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public void setId(String id) {
        this.protect("id");
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setSuffixDn(Dn suffixDn) {
        this.protect("suffixDn");
        if (!suffixDn.isSchemaAware()) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_218, (Object[])new Object[]{suffixDn.getName()}));
        }
        this.suffixDn = suffixDn;
    }

    @Override
    public Dn getSuffixDn() {
        return this.suffixDn;
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) throws Exception {
        this.master.setProperty(propertyName, propertyValue);
    }

    @Override
    public String getProperty(String propertyName) throws Exception {
        return this.master.getProperty(propertyName);
    }

    protected void setupUserIndices() throws Exception {
        HashMap tmp = new HashMap();
        for (String oid : this.userIndices.keySet()) {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
            MatchingRule mr = attributeType.getEquality();
            if (mr != null) {
                Index<?, E, ID> index = this.userIndices.get(oid);
                index = this.convertAndInit(index);
                tmp.put(oid, index);
                continue;
            }
            LOG.error(I18n.err((I18n)I18n.ERR_4, (Object[])new Object[]{attributeType.getName()}));
        }
        this.userIndices = tmp;
    }

    protected void setupSystemIndices() throws Exception {
        GenericIndex index;
        if (this.getPresenceIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.3");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getOneLevelIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.4");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getSubLevelIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.43");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getRdnIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.50");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getAliasIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.7");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getOneAliasIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.5");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getSubAliasIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.18060.0.4.1.2.6");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getObjectClassIndex() == null) {
            index = new GenericIndex("2.5.4.0");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getEntryUuidIndex() == null) {
            index = new GenericIndex("1.3.6.1.1.16.4");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        if (this.getEntryCsnIndex() == null) {
            index = new GenericIndex("1.3.6.1.4.1.4203.666.1.7");
            index.setWkDirPath(this.partitionPath);
            this.addIndex(index);
        }
        for (String oid : this.systemIndices.keySet()) {
            Index<?, E, ID> index2 = this.systemIndices.get(oid);
            index2 = this.convertAndInit(index2);
            this.systemIndices.put(oid, index2);
        }
        this.rdnIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.50");
        this.presenceIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.3");
        this.oneLevelIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.4");
        this.subLevelIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.43");
        this.aliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.7");
        this.oneAliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.5");
        this.subAliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.6");
        this.objectClassIdx = this.systemIndices.get("2.5.4.0");
        this.entryUuidIdx = this.systemIndices.get("1.3.6.1.1.16.4");
        this.entryCsnIdx = this.systemIndices.get("1.3.6.1.4.1.4203.666.1.7");
    }

    protected abstract Index<?, E, ID> convertAndInit(Index<?, E, ID> var1) throws Exception;

    protected abstract ID getRootId();

    protected ID getSuffixId() throws Exception {
        return this.getEntryId(this.getSuffixDn());
    }

    @Override
    public Iterator<String> userIndices() {
        return this.userIndices.keySet().iterator();
    }

    @Override
    public Iterator<String> systemIndices() {
        return this.systemIndices.keySet().iterator();
    }

    @Override
    public boolean hasIndexOn(String id) throws LdapException {
        return this.hasUserIndexOn(id) || this.hasSystemIndexOn(id);
    }

    @Override
    public boolean hasIndexOn(AttributeType attributeType) throws LdapException {
        return this.hasUserIndexOn(attributeType) || this.hasSystemIndexOn(attributeType);
    }

    @Override
    public boolean hasUserIndexOn(String id) throws LdapException {
        return this.userIndices.containsKey(this.schemaManager.getAttributeTypeRegistry().getOidByName(id));
    }

    @Override
    public boolean hasUserIndexOn(AttributeType attributeType) throws LdapException {
        return this.userIndices.containsKey(attributeType.getOid());
    }

    @Override
    public boolean hasSystemIndexOn(String id) throws LdapException {
        return this.systemIndices.containsKey(this.schemaManager.getAttributeTypeRegistry().getOidByName(id));
    }

    @Override
    public boolean hasSystemIndexOn(AttributeType attributeType) throws LdapException {
        return this.systemIndices.containsKey(attributeType.getOid());
    }

    @Override
    public Set<Index<?, E, ID>> getUserIndices() {
        return new HashSet(this.userIndices.values());
    }

    @Override
    public Index<?, E, ID> getIndex(String id) throws IndexNotFoundException {
        try {
            return this.getIndex(this.schemaManager.lookupAttributeTypeRegistry(id));
        }
        catch (LdapException e) {
            String msg = I18n.err((I18n)I18n.ERR_128, (Object[])new Object[]{id});
            LOG.error(msg, (Throwable)e);
            throw new IndexNotFoundException(msg, id, e);
        }
    }

    @Override
    public Index<?, E, ID> getIndex(AttributeType attributeType) throws IndexNotFoundException {
        String id = attributeType.getOid();
        if (this.userIndices.containsKey(id)) {
            return this.userIndices.get(id);
        }
        if (this.systemIndices.containsKey(id)) {
            return this.systemIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_3, (Object[])new Object[]{id, id}));
    }

    @Override
    public Index<?, E, ID> getUserIndex(String id) throws IndexNotFoundException {
        try {
            return this.getUserIndex(this.schemaManager.lookupAttributeTypeRegistry(id));
        }
        catch (LdapException e) {
            String msg = I18n.err((I18n)I18n.ERR_128, (Object[])new Object[]{id});
            LOG.error(msg, (Throwable)e);
            throw new IndexNotFoundException(msg, id, e);
        }
    }

    @Override
    public Index<?, E, ID> getUserIndex(AttributeType attributeType) throws IndexNotFoundException {
        String id = attributeType.getOid();
        if (this.userIndices.containsKey(id)) {
            return this.userIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_3, (Object[])new Object[]{id, id}));
    }

    @Override
    public Index<?, E, ID> getSystemIndex(String id) throws IndexNotFoundException {
        try {
            return this.getSystemIndex(this.schemaManager.lookupAttributeTypeRegistry(id));
        }
        catch (LdapException e) {
            String msg = I18n.err((I18n)I18n.ERR_128, (Object[])new Object[]{id});
            LOG.error(msg, (Throwable)e);
            throw new IndexNotFoundException(msg, id, e);
        }
    }

    @Override
    public Index<?, E, ID> getSystemIndex(AttributeType attributeType) throws IndexNotFoundException {
        String id = attributeType.getOid();
        if (this.systemIndices.containsKey(id)) {
            return this.systemIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_2, (Object[])new Object[]{id, id}));
    }

    @Override
    public void addIndex(Index<?, E, ID> index) throws Exception {
        this.protect("addIndex");
        String oid = index.getAttributeId();
        if (!Oid.isOid((String)oid)) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_309, (Object[])new Object[]{oid}));
        }
        if (SYS_INDEX_OIDS.contains(oid)) {
            this.systemIndices.put(oid, index);
        } else {
            this.userIndices.put(oid, index);
        }
    }

    @Override
    public Index<ParentIdAndRdn<ID>, E, ID> getRdnIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.50");
    }

    @Override
    public Index<String, E, ID> getNdnIndex() {
        return this.getEntryUuidIndex();
    }

    @Override
    public Index<String, E, ID> getPresenceIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.3");
    }

    @Override
    public Index<ID, E, ID> getOneLevelIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.4");
    }

    @Override
    public Index<ID, E, ID> getSubLevelIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.43");
    }

    @Override
    public Index<String, E, ID> getAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.7");
    }

    @Override
    public Index<ID, E, ID> getOneAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.5");
    }

    @Override
    public Index<ID, E, ID> getSubAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.6");
    }

    @Override
    public Index<String, E, ID> getObjectClassIndex() {
        return this.systemIndices.get("2.5.4.0");
    }

    @Override
    public Index<String, E, ID> getEntryUuidIndex() {
        return this.systemIndices.get("1.3.6.1.1.16.4");
    }

    @Override
    public Index<String, E, ID> getEntryCsnIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.4203.666.1.7");
    }

    @Override
    public int count() throws Exception {
        return this.master.count();
    }

    @Override
    public int getChildCount(ID id) throws Exception {
        return this.oneLevelIdx.count(id);
    }

    @Override
    public ID getEntryId(Dn dn) throws Exception {
        if (!dn.isSchemaAware()) {
            dn.apply(this.schemaManager);
        }
        int dnSize = dn.size();
        ParentIdAndRdn<Object> key = new ParentIdAndRdn<ID>(this.getRootId(), this.suffixDn.getRdns());
        Comparable curEntryId = (Comparable)this.rdnIdx.forwardLookup(key);
        for (int i = this.suffixDn.size(); i < dnSize && (curEntryId = (Comparable)this.rdnIdx.forwardLookup(key = new ParentIdAndRdn<Comparable>(curEntryId, dn.getRdn(dnSize - 1 - i)))) != null; ++i) {
        }
        return (ID)curEntryId;
    }

    @Override
    public Dn getEntryDn(ID id) throws Exception {
        return this.buildEntryDn(id);
    }

    @Override
    public ID getParentId(ID childId) throws Exception {
        ParentIdAndRdn<ID> key = this.rdnIdx.reverseLookup(childId);
        if (key == null) {
            return null;
        }
        return key.getParentId();
    }

    @Override
    public Entry lookup(ID id) throws Exception {
        Entry entry = this.master.get(id);
        if (entry != null) {
            Dn dn = this.buildEntryDn(id);
            entry.setDn(dn);
            return entry;
        }
        return null;
    }

    @Override
    public IndexCursor<ID, E, ID> list(ID id) throws Exception {
        IndexCursor<ID, E, ID> cursor = this.oneLevelIdx.forwardCursor(id);
        cursor.beforeValue(id, null);
        return cursor;
    }

    @Override
    public synchronized void add(Entry entry) throws Exception {
        ID parentId;
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err((I18n)I18n.ERR_215, (Object[])new Object[0]));
        }
        Dn entryDn = entry.getDn();
        if (this.checkHasEntryDuringAdd && this.getEntryId(entryDn) != null) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_250_ENTRY_ALREADY_EXISTS, (Object[])new Object[]{entryDn.getName()}));
            throw ne;
        }
        Comparable id = (Comparable)this.master.getNextId(entry);
        Dn parentDn = null;
        ParentIdAndRdn<ID> key = null;
        if (entryDn.equals((Object)this.suffixDn)) {
            parentId = this.getRootId();
            key = new ParentIdAndRdn<ID>(parentId, this.suffixDn.getRdns());
        } else {
            parentDn = entryDn.getParent();
            parentId = this.getEntryId(parentDn);
            if (parentId == null) {
                parentId = this.getEntryId(parentDn);
            }
            key = new ParentIdAndRdn<ID>(parentId, entryDn.getRdn());
        }
        if (parentId == null) {
            throw new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_216, (Object[])new Object[]{parentDn}));
        }
        this.rdnIdx.add(key, id);
        Attribute objectClass = entry.get(this.OBJECT_CLASS_AT);
        if (objectClass == null) {
            String msg = I18n.err((I18n)I18n.ERR_217, (Object[])new Object[]{entryDn.getName(), entry});
            ResultCodeEnum rc = ResultCodeEnum.OBJECT_CLASS_VIOLATION;
            LdapSchemaViolationException e = new LdapSchemaViolationException(rc, msg);
            throw e;
        }
        for (Value value : objectClass) {
            this.objectClassIdx.add(value.getString(), id);
        }
        if (objectClass.contains(new String[]{"alias"})) {
            Attribute aliasAttr = entry.get(this.ALIASED_OBJECT_NAME_AT);
            this.addAliasIndices(id, entryDn, aliasAttr.getString());
        }
        if (!Character.isDigit(entryDn.getNormName().charAt(0))) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_218, (Object[])new Object[]{entryDn.getNormName()}));
        }
        this.oneLevelIdx.add((Comparable)parentId, id);
        Attribute entryCsn = entry.get(this.ENTRY_CSN_AT);
        if (entryCsn == null) {
            String msg = I18n.err((I18n)I18n.ERR_219, (Object[])new Object[]{entryDn.getName(), entry});
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, msg);
        }
        this.entryCsnIdx.add(entryCsn.getString(), id);
        Attribute entryUuid = entry.get(this.ENTRY_UUID_AT);
        if (entryUuid == null) {
            String msg = I18n.err((I18n)I18n.ERR_220, (Object[])new Object[]{entryDn.getName(), entry});
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, msg);
        }
        this.entryUuidIdx.add(entryUuid.getString(), id);
        ID tempId = parentId;
        while (tempId != null && !tempId.equals(this.getRootId()) && !tempId.equals(this.getSuffixId())) {
            this.subLevelIdx.add((Comparable)tempId, id);
            tempId = this.getParentId(tempId);
        }
        this.subLevelIdx.add(id, id);
        for (Attribute attribute : entry) {
            String attributeOid = attribute.getAttributeType().getOid();
            if (!this.hasUserIndexOn(attribute.getAttributeType())) continue;
            Index<?, E, Comparable> idx = this.getUserIndex(attributeOid);
            for (Value value : attribute) {
                idx.add(value.getValue(), id);
            }
            this.presenceIdx.add(attributeOid, id);
        }
        entry.put("entryParentId", new String[]{parentId.toString()});
        this.master.put(id, entry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    @Override
    public synchronized void modify(Dn dn, ModificationOperation modOp, Entry mods) throws Exception {
        if (mods instanceof ClonedServerEntry) {
            throw new Exception(I18n.err((I18n)I18n.ERR_215, (Object[])new Object[0]));
        }
        ID id = this.getEntryId(dn);
        Entry entry = this.master.get(id);
        block5: for (AttributeType attributeType : mods.getAttributeTypes()) {
            Attribute attr = mods.get(attributeType);
            switch (modOp) {
                case ADD_ATTRIBUTE: {
                    this.add(id, entry, attr);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.remove(id, entry, attr);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.replace(id, entry, attr);
                    continue block5;
                }
            }
            throw new LdapException(I18n.err((I18n)I18n.ERR_221, (Object[])new Object[0]));
        }
        this.updateCsnIndex(entry, id);
        this.master.put(id, entry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    @Override
    public synchronized Entry modify(Dn dn, List<Modification> mods) throws Exception {
        ID id = this.getEntryId(dn);
        Entry entry = this.master.get(id);
        block5: for (Modification mod : mods) {
            Attribute attrMods = mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    this.add(id, entry, attrMods);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.remove(id, entry, attrMods);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.replace(id, entry, attrMods);
                    continue block5;
                }
            }
            throw new LdapException(I18n.err((I18n)I18n.ERR_221, (Object[])new Object[0]));
        }
        this.updateCsnIndex(entry, id);
        this.master.put(id, entry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
        return entry;
    }

    @Override
    public synchronized void delete(ID id) throws Exception {
        Entry entry = this.master.get(id);
        Attribute objectClass = entry.get(this.OBJECT_CLASS_AT);
        if (objectClass.contains(new String[]{"alias"})) {
            this.dropAliasIndices(id);
        }
        for (Value value : objectClass) {
            this.objectClassIdx.drop(value.getString(), id);
        }
        this.rdnIdx.drop(id);
        this.oneLevelIdx.drop(id);
        this.subLevelIdx.drop(id);
        this.entryCsnIdx.drop(id);
        this.entryUuidIdx.drop(id);
        for (Attribute attribute : entry) {
            String attributeOid = attribute.getAttributeType().getOid();
            if (!this.hasUserIndexOn(attribute.getAttributeType())) continue;
            Index<?, E, ID> index = this.getUserIndex(attributeOid);
            for (Value value : attribute) {
                index.drop(value.getValue(), id);
            }
            this.presenceIdx.drop(attributeOid, id);
        }
        this.master.delete(id);
        if (id.equals(this.getDefaultId())) {
            this.master.resetCounter();
        }
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    @Override
    public synchronized void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, Entry entry) throws Exception {
        ID id = this.getEntryId(dn);
        if (entry == null) {
            entry = this.lookup(id);
        }
        Dn updn = entry.getDn();
        newRdn.apply(this.schemaManager);
        for (Ava newAtav : newRdn) {
            String newNormType = newAtav.getNormType();
            Object newNormValue = newAtav.getNormValue().getValue();
            AttributeType newRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(newNormType);
            entry.add(newRdnAttrType, new Value[]{newAtav.getNormValue()});
            if (!this.hasUserIndexOn(newNormType)) continue;
            Index<?, E, ID> index = this.getUserIndex(newNormType);
            index.add(newNormValue, id);
            if (this.presenceIdx.forward(newNormType, id)) continue;
            this.presenceIdx.add(newNormType, id);
        }
        if (deleteOldRdn) {
            Rdn oldRdn = updn.getRdn();
            for (Ava oldAtav : oldRdn) {
                boolean mustRemove = true;
                for (Ava newAtav : newRdn) {
                    if (!oldAtav.equals((Object)newAtav)) continue;
                    mustRemove = false;
                    break;
                }
                if (!mustRemove) continue;
                String oldNormType = oldAtav.getNormType();
                String oldNormValue = oldAtav.getNormValue().getString();
                AttributeType oldRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(oldNormType);
                entry.remove(oldRdnAttrType, new String[]{oldNormValue});
                if (!this.hasUserIndexOn(oldNormType)) continue;
                Index<?, E, ID> index = this.getUserIndex(oldNormType);
                index.drop(oldNormValue, id);
                if (null != index.reverseLookup(id)) continue;
                this.presenceIdx.drop(oldNormType, id);
            }
        }
        ID parentId = this.getParentId(id);
        this.rdnIdx.drop(id);
        ParentIdAndRdn<ID> key = new ParentIdAndRdn<ID>(parentId, newRdn);
        this.rdnIdx.add(key, id);
        this.master.put(id, entry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    @Override
    public synchronized void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn) throws Exception {
        this.rename(dn, newRdn, deleteOldRdn, null);
    }

    @Override
    public synchronized void moveAndRename(Dn oldDn, Dn newSuperiorDn, Rdn newRdn, Entry modifiedEntry, boolean deleteOldRdn) throws Exception {
        ID oldId = this.getEntryId(oldDn);
        if (oldId == null) {
            LdapNoSuchObjectException nse = new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_256_NO_SUCH_OBJECT, (Object[])new Object[]{oldDn}));
            throw nse;
        }
        ID newSuperiorId = this.getEntryId(newSuperiorDn);
        if (newSuperiorId == null) {
            LdapNoSuchObjectException nse = new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_256_NO_SUCH_OBJECT, (Object[])new Object[]{newSuperiorDn}));
            throw nse;
        }
        Dn newDn = newSuperiorDn.add(newRdn);
        ID newId = this.getEntryId(newDn);
        if (newId != null) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_250_ENTRY_ALREADY_EXISTS, (Object[])new Object[]{newSuperiorDn.getName()}));
            throw ne;
        }
        this.rename(oldDn, newRdn, deleteOldRdn, modifiedEntry);
        this.moveAndRename(oldDn, oldId, newSuperiorDn, newRdn, modifiedEntry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    @Override
    public synchronized void move(Dn oldDn, Dn newSuperiorDn, Dn newDn) throws Exception {
        this.move(oldDn, newSuperiorDn, newDn, null);
    }

    @Override
    public synchronized void move(Dn oldDn, Dn newSuperiorDn, Dn newDn, Entry modifiedEntry) throws Exception {
        ID newParentId = this.getEntryId(newSuperiorDn);
        if (newParentId == null) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_256_NO_SUCH_OBJECT, (Object[])new Object[]{newSuperiorDn.getName()}));
            throw ne;
        }
        ID newId = this.getEntryId(newDn);
        if (newId != null) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_250_ENTRY_ALREADY_EXISTS, (Object[])new Object[]{newSuperiorDn.getName()}));
            throw ne;
        }
        ID entryId = this.getEntryId(oldDn);
        ID oldParentId = this.getParentId(entryId);
        this.dropMovedAliasIndices(oldDn);
        this.oneLevelIdx.drop(oldParentId, entryId);
        this.oneLevelIdx.add(newParentId, entryId);
        this.updateSubLevelIndex(entryId, oldParentId, newParentId);
        this.rdnIdx.drop(entryId);
        ParentIdAndRdn<ID> key = new ParentIdAndRdn<ID>(newParentId, oldDn.getRdn());
        this.rdnIdx.add(key, entryId);
        String aliasTarget = this.aliasIdx.reverseLookup(entryId);
        if (null != aliasTarget) {
            this.addAliasIndices(entryId, this.buildEntryDn(entryId), aliasTarget);
        }
        if (modifiedEntry == null) {
            modifiedEntry = this.lookup(entryId);
        }
        modifiedEntry.put("entryParentId", new String[]{newParentId.toString()});
        this.master.put(entryId, modifiedEntry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    protected Dn buildEntryDn(ID id) throws Exception {
        ParentIdAndRdn<ID> cur;
        ID parentId = id;
        ArrayList<Rdn> rdnList = new ArrayList<Rdn>();
        StringBuilder upName = new StringBuilder();
        String normName = "";
        do {
            Rdn[] rdns;
            cur = this.rdnIdx.reverseLookup(parentId);
            for (Rdn rdn : rdns = cur.getRdns()) {
                if (rdnList.isEmpty()) {
                    normName = rdn.getNormName();
                    upName.append(rdn.getName());
                } else {
                    normName = normName + "," + rdn.getNormName();
                    upName.append(',').append(rdn.getName());
                }
                rdnList.add(rdn);
            }
        } while (!(parentId = cur.getParentId()).equals(this.getRootId()));
        Dn dn = new Dn(this.schemaManager, new String[]{upName.toString()});
        return dn;
    }

    protected void add(ID id, Entry entry, Attribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err((I18n)I18n.ERR_215, (Object[])new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        if (modsOid.equals("2.5.4.0")) {
            for (Value value : mods) {
                this.objectClassIdx.add(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(mods.getAttributeType())) {
            Index<?, E, ID> index = this.getUserIndex(modsOid);
            for (Value value : mods) {
                index.add(value.getValue(), id);
            }
            if (!this.presenceIdx.forward(modsOid, id)) {
                this.presenceIdx.add(modsOid, id);
            }
        }
        for (Value value : mods) {
            entry.add(mods.getAttributeType(), new Value[]{value});
        }
        if (modsOid.equals("2.5.4.1")) {
            Dn ndn = this.getEntryDn(id);
            this.addAliasIndices(id, ndn, mods.getString());
        }
    }

    protected void replace(ID id, Entry entry, Attribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err((I18n)I18n.ERR_215, (Object[])new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        if (mods.getAttributeType().equals((Object)this.OBJECT_CLASS_AT)) {
            if (this.objectClassIdx.reverse(id)) {
                this.objectClassIdx.drop(id);
            }
            for (Value value : mods) {
                this.objectClassIdx.add(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(mods.getAttributeType())) {
            Index<?, E, ID> index = this.getUserIndex(modsOid);
            if (index.reverse(id)) {
                index.drop(id);
            }
            for (Value value : mods) {
                index.add(value.getValue(), id);
            }
            if (null == index.reverseLookup(id)) {
                this.presenceIdx.drop(modsOid, id);
            }
        }
        String aliasAttributeOid = this.schemaManager.getAttributeTypeRegistry().getOidByName("aliasedObjectName");
        if (mods.getAttributeType().equals((Object)this.ALIASED_OBJECT_NAME_AT)) {
            this.dropAliasIndices(id);
        }
        if (mods.size() > 0) {
            entry.put(new Attribute[]{mods});
        } else {
            entry.remove(new Attribute[]{mods});
        }
        if (modsOid.equals(aliasAttributeOid) && mods.size() > 0) {
            Dn entryDn = this.getEntryDn(id);
            this.addAliasIndices(id, entryDn, mods.getString());
        }
    }

    protected void remove(ID id, Entry entry, Attribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err((I18n)I18n.ERR_215, (Object[])new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        if (mods.getAttributeType().equals((Object)this.OBJECT_CLASS_AT)) {
            if (mods.size() == 0) {
                this.objectClassIdx.drop(id);
            } else {
                for (Value value : mods) {
                    this.objectClassIdx.drop(value.getString(), id);
                }
            }
        } else if (this.hasUserIndexOn(mods.getAttributeType())) {
            Index<?, E, ID> index = this.getUserIndex(modsOid);
            if (mods.size() == 0) {
                index.drop(id);
            } else {
                for (Value value : mods) {
                    index.drop(value.getValue(), id);
                }
            }
            if (null == index.reverseLookup(id)) {
                this.presenceIdx.drop(modsOid, id);
            }
        }
        AttributeType attrType = this.schemaManager.lookupAttributeTypeRegistry(modsOid);
        if (mods.size() == 0) {
            entry.removeAttributes(new AttributeType[]{mods.getAttributeType()});
        } else {
            Attribute entryAttr = entry.get(mods.getAttributeType());
            for (Value value : mods) {
                entryAttr.remove(new Value[]{value});
            }
            if (entryAttr.size() == 0) {
                entry.removeAttributes(new String[]{entryAttr.getId()});
            }
        }
        if (mods.getAttributeType().equals((Object)this.ALIASED_OBJECT_NAME_AT)) {
            this.dropAliasIndices(id);
        }
    }

    protected void addAliasIndices(ID aliasId, Dn aliasDn, String aliasTarget) throws Exception {
        Dn normalizedAliasTargetDn = new Dn(this.schemaManager, new String[]{aliasTarget});
        if (!normalizedAliasTargetDn.isDescendantOf(this.suffixDn)) {
            String msg = I18n.err((I18n)I18n.ERR_225, (Object[])new Object[]{this.suffixDn.getName()});
            LdapAliasDereferencingException e = new LdapAliasDereferencingException(msg);
            throw e;
        }
        ID targetId = this.getEntryId(normalizedAliasTargetDn);
        if (null == targetId) {
            String msg = I18n.err((I18n)I18n.ERR_581, (Object[])new Object[]{aliasDn.getName(), aliasTarget});
            LdapAliasException e = new LdapAliasException(msg);
            throw e;
        }
        if (null != this.aliasIdx.reverseLookup(targetId)) {
            String msg = I18n.err((I18n)I18n.ERR_227, (Object[])new Object[0]);
            LdapAliasDereferencingException e = new LdapAliasDereferencingException(msg);
            throw e;
        }
        this.aliasIdx.add(normalizedAliasTargetDn.getNormName(), aliasId);
        Dn ancestorDn = aliasDn.getParent();
        ID ancestorId = this.getEntryId(ancestorDn);
        Dn normalizedAliasTargetParentDn = normalizedAliasTargetDn.getParent();
        if (!aliasDn.isDescendantOf(normalizedAliasTargetParentDn)) {
            this.oneAliasIdx.add(ancestorId, targetId);
        }
        while (!ancestorDn.equals((Object)this.suffixDn) && null != ancestorId) {
            if (!normalizedAliasTargetDn.isDescendantOf(ancestorDn)) {
                this.subAliasIdx.add(ancestorId, targetId);
            }
            ancestorDn = ancestorDn.getParent();
            ancestorId = this.getEntryId(ancestorDn);
        }
    }

    protected void dropAliasIndices(ID aliasId) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        ID targetId = this.getEntryId(new Dn(this.schemaManager, new String[]{targetDn}));
        if (targetId == null) {
            return;
        }
        Dn aliasDn = this.getEntryDn(aliasId);
        Dn ancestorDn = aliasDn.getParent();
        ID ancestorId = this.getEntryId(ancestorDn);
        this.oneAliasIdx.drop(ancestorId, targetId);
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals((Object)this.suffixDn) && ancestorDn.size() > this.suffixDn.size()) {
            ancestorDn = ancestorDn.getParent();
            ancestorId = this.getEntryId(ancestorDn);
            this.subAliasIdx.drop(ancestorId, targetId);
        }
        this.aliasIdx.drop(aliasId);
    }

    protected void dropMovedAliasIndices(Dn movedBase) throws Exception {
        ID movedBaseId = this.getEntryId(movedBase);
        if (this.aliasIdx.reverseLookup(movedBaseId) != null) {
            this.dropAliasIndices(movedBaseId, movedBase);
        }
    }

    protected void dropAliasIndices(ID aliasId, Dn movedBase) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        ID targetId = this.getEntryId(new Dn(this.schemaManager, new String[]{targetDn}));
        Dn aliasDn = this.getEntryDn(aliasId);
        Dn ancestorDn = new Dn(this.schemaManager, new Rdn[]{movedBase.getRdn(movedBase.size() - 1)});
        ID ancestorId = this.getEntryId(ancestorDn);
        if (aliasDn.equals((Object)movedBase)) {
            this.oneAliasIdx.drop(ancestorId, targetId);
        }
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals((Object)this.suffixDn)) {
            ancestorDn = new Dn(this.schemaManager, new Rdn[]{ancestorDn.getRdn(ancestorDn.size() - 1)});
            ancestorId = this.getEntryId(ancestorDn);
            this.subAliasIdx.drop(ancestorId, targetId);
        }
    }

    protected void moveAndRename(Dn oldDn, ID childId, Dn newSuperior, Rdn newRdn, Entry modifiedEntry) throws Exception {
        ID newParentId = this.getEntryId(newSuperior);
        ID oldParentId = this.getParentId(childId);
        this.dropMovedAliasIndices(oldDn);
        this.oneLevelIdx.drop(oldParentId, childId);
        this.oneLevelIdx.add(newParentId, childId);
        this.updateSubLevelIndex(childId, oldParentId, newParentId);
        this.rdnIdx.drop(childId);
        ParentIdAndRdn<ID> key = new ParentIdAndRdn<ID>(newParentId, newRdn);
        this.rdnIdx.add(key, childId);
        String aliasTarget = this.aliasIdx.reverseLookup(childId);
        if (null != aliasTarget) {
            this.addAliasIndices(childId, this.buildEntryDn(childId), aliasTarget);
        }
        if (modifiedEntry != null) {
            modifiedEntry.put("entryParentId", new String[]{newParentId.toString()});
            this.master.put(childId, modifiedEntry);
        }
    }

    protected void updateSubLevelIndex(ID entryId, ID oldParentId, ID newParentId) throws Exception {
        ID tempId = oldParentId;
        ArrayList<ID> parentIds = new ArrayList<ID>();
        while (tempId != null && !tempId.equals(this.getRootId()) && !tempId.equals(this.getSuffixId())) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        IndexCursor<ID, E, ID> cursor = this.subLevelIdx.forwardCursor(entryId);
        ArrayList childIds = new ArrayList();
        childIds.add(entryId);
        while (cursor.next()) {
            childIds.add(((IndexEntry)cursor.get()).getId());
        }
        for (Comparable pid : parentIds) {
            for (Comparable cid : childIds) {
                this.subLevelIdx.drop(pid, cid);
            }
        }
        parentIds.clear();
        tempId = newParentId;
        while (tempId != null && !tempId.equals(this.getRootId()) && !tempId.equals(this.getSuffixId())) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        for (Comparable id : parentIds) {
            for (Comparable cid : childIds) {
                this.subLevelIdx.add(id, cid);
            }
        }
    }

    private void updateCsnIndex(Entry entry, ID id) throws Exception {
        this.entryCsnIdx.drop(id);
        this.entryCsnIdx.add(entry.get("entryCSN").getString(), id);
    }

    public boolean isCheckHasEntryDuringAdd() {
        return this.checkHasEntryDuringAdd;
    }

    public void setCheckHasEntryDuringAdd(boolean checkHasEntryDuringAdd) {
        this.checkHasEntryDuringAdd = checkHasEntryDuringAdd;
    }
}

