/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.impl.avl;

import org.apache.directory.server.core.partition.impl.btree.LongComparator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.ParentIdAndRdnComparator;
import org.apache.directory.server.xdbm.impl.avl.AvlIndex;
import org.apache.directory.server.xdbm.impl.avl.AvlTable;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlRdnIndex<E>
extends AvlIndex<ParentIdAndRdn<Long>, E> {
    public AvlRdnIndex() {
    }

    public AvlRdnIndex(String attributeId) {
        super(attributeId);
    }

    @Override
    public void init(SchemaManager schemaManager, AttributeType attributeType) throws Exception {
        this.attributeType = attributeType;
        MatchingRule mr = attributeType.getEquality();
        if (mr == null) {
            mr = attributeType.getOrdering();
        }
        if (mr == null) {
            mr = attributeType.getSubstring();
        }
        this.normalizer = mr.getNormalizer();
        if (this.normalizer == null) {
            throw new Exception(I18n.err((I18n)I18n.ERR_212, (Object[])new Object[]{attributeType}));
        }
        ParentIdAndRdnComparator comp = new ParentIdAndRdnComparator(mr.getOid());
        LongComparator.INSTANCE.setSchemaManager(schemaManager);
        this.forward = new AvlTable(attributeType.getName(), comp, LongComparator.INSTANCE, false);
        this.reverse = new AvlTable(attributeType.getName(), LongComparator.INSTANCE, comp, false);
    }

    @Override
    public void add(ParentIdAndRdn<Long> rdn, Long entryId) throws Exception {
        this.forward.put(rdn, entryId);
        this.reverse.put(entryId, rdn);
    }

    @Override
    public void drop(Long entryId) throws Exception {
        ParentIdAndRdn rdn = (ParentIdAndRdn)this.reverse.get(entryId);
        this.forward.remove(rdn);
        this.reverse.remove(entryId);
    }

    @Override
    public void drop(ParentIdAndRdn<Long> rdn, Long id) throws Exception {
        long val = (Long)this.forward.get(rdn);
        if (val == id) {
            this.forward.remove(rdn);
            this.reverse.remove(val);
        }
    }

    @Override
    public ParentIdAndRdn<Long> getNormalized(ParentIdAndRdn<Long> rdn) throws Exception {
        return rdn;
    }
}

