/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import javax.naming.directory.SearchControls;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.EmptyIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.SingletonIndexCursor;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.ScopeNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSearchEngine<ID extends Comparable<ID>>
implements SearchEngine<Entry, ID> {
    private final Optimizer optimizer;
    private final Store<Entry, ID> db;
    private final CursorBuilder<ID> cursorBuilder;
    private final EvaluatorBuilder<ID> evaluatorBuilder;

    public DefaultSearchEngine(Store<Entry, ID> db, CursorBuilder<ID> cursorBuilder, EvaluatorBuilder<ID> evaluatorBuilder, Optimizer optimizer) {
        this.db = db;
        this.optimizer = optimizer;
        this.cursorBuilder = cursorBuilder;
        this.evaluatorBuilder = evaluatorBuilder;
    }

    @Override
    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    @Override
    public IndexCursor<ID, Entry, ID> cursor(Dn base, AliasDerefMode aliasDerefMode, ExprNode filter, SearchControls searchCtls) throws Exception {
        ID baseId = this.db.getEntryId(base);
        if (baseId == null) {
            if (this.db.getSuffixDn().equals((Object)base)) {
                return new EmptyIndexCursor();
            }
            throw new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_648, (Object[])new Object[]{base}));
        }
        String aliasedBase = this.db.getAliasIndex().reverseLookup(baseId);
        Dn effectiveBase = null == aliasedBase || !aliasDerefMode.isDerefFindingBase() ? base : new Dn(new String[]{aliasedBase});
        if (searchCtls.getSearchScope() == 0) {
            ID effectiveBaseId = baseId;
            if (effectiveBase != base) {
                effectiveBaseId = this.db.getEntryId(effectiveBase);
            }
            ForwardIndexEntry indexEntry = new ForwardIndexEntry();
            indexEntry.setId(effectiveBaseId);
            this.optimizer.annotate(filter);
            Evaluator evaluator = this.evaluatorBuilder.build(filter);
            if (evaluator.evaluate(indexEntry)) {
                return new SingletonIndexCursor(indexEntry);
            }
            return new EmptyIndexCursor();
        }
        AndNode root = new AndNode();
        ScopeNode node = new ScopeNode(aliasDerefMode, effectiveBase, SearchScope.getSearchScope((int)searchCtls.getSearchScope()));
        root.getChildren().add(node);
        root.getChildren().add(filter);
        this.optimizer.annotate((ExprNode)root);
        return this.cursorBuilder.build((ExprNode)root);
    }

    @Override
    public Evaluator<? extends ExprNode, Entry, ID> evaluator(ExprNode filter) throws Exception {
        return this.evaluatorBuilder.build(filter);
    }
}

