/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllEntriesCursor
extends AbstractIndexCursor<String> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private IndexEntry<String, String> indexEntry = new IndexEntry();
    private final Cursor<IndexEntry<String, String>> wrapped;

    @Override
    protected String getUnsupportedMessage() {
        return "Unsupported operation";
    }

    public AllEntriesCursor(Store store) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating AllEntriesCursor {}", (Object)this);
        }
        this.wrapped = new IndexCursorAdaptor(store.getMasterTable().cursor(), true);
    }

    @Override
    public void after(IndexEntry<String, String> indexEntry) throws LdapException, CursorException {
        this.checkNotClosed("after()");
    }

    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
    }

    @Override
    public boolean available() {
        return this.wrapped.available();
    }

    @Override
    public void before(IndexEntry<String, String> indexEntry) throws LdapException, CursorException {
        this.checkNotClosed("before()");
    }

    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
    }

    public boolean first() throws LdapException, CursorException {
        this.checkNotClosed("first()");
        return this.wrapped.first();
    }

    public IndexEntry<String, String> get() throws CursorException {
        this.checkNotClosed("get()");
        IndexEntry wrappedEntry = (IndexEntry)this.wrapped.get();
        this.indexEntry.setId((String)wrappedEntry.getKey());
        this.indexEntry.setKey((String)wrappedEntry.getKey());
        this.indexEntry.setEntry(null);
        return this.indexEntry;
    }

    public boolean last() throws LdapException, CursorException {
        this.checkNotClosed("last()");
        return this.wrapped.last();
    }

    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed("next()");
        return this.wrapped.next();
    }

    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed("previous()");
        return this.wrapped.previous();
    }

    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AllEntriesCursor {}", (Object)this);
        }
        this.wrapped.close();
    }

    public void close(Exception cause) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AllEntriesCursor {}", (Object)this);
        }
        this.wrapped.close(cause);
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("AllEntriesCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append(" :\n");
        sb.append(this.wrapped.toString(tabs + "    "));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

