/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import org.apache.directory.shared.asn1.ber.AbstractContainer;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageGrammar;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.BindRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.BindResponseCodec;
import org.apache.directory.shared.ldap.codec.compare.CompareRequestCodec;
import org.apache.directory.shared.ldap.codec.compare.CompareResponseCodec;
import org.apache.directory.shared.ldap.codec.controls.AbstractControl;
import org.apache.directory.shared.ldap.codec.del.DelRequestCodec;
import org.apache.directory.shared.ldap.codec.del.DelResponseCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequestCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseCodec;
import org.apache.directory.shared.ldap.codec.intermediate.IntermediateResponseCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequestCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponseCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequestCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponseCodec;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultDoneCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntryCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultReferenceCodec;
import org.apache.directory.shared.ldap.codec.unbind.UnBindRequestCodec;
import org.apache.directory.shared.ldap.message.spi.BinaryAttributeDetector;

public class LdapMessageContainer
extends AbstractContainer {
    private LdapMessageCodec ldapMessage;
    private final BinaryAttributeDetector binaryAttributeDetector;
    private int messageId;
    private AbstractControl currentControl;

    public LdapMessageContainer() {
        this(new BinaryAttributeDetector(){

            public boolean isBinary(String attributeId) {
                return false;
            }
        });
    }

    public LdapMessageContainer(BinaryAttributeDetector binaryAttributeDetector) {
        this.stateStack = new int[10];
        this.grammar = LdapMessageGrammar.getInstance();
        this.states = LdapStatesEnum.getInstance();
        this.binaryAttributeDetector = binaryAttributeDetector;
    }

    public LdapMessageCodec getLdapMessage() {
        return this.ldapMessage;
    }

    public LdapResponseCodec getLdapResponse() {
        return (LdapResponseCodec)this.ldapMessage;
    }

    public AbandonRequestCodec getAbandonRequest() {
        return (AbandonRequestCodec)this.ldapMessage;
    }

    public AddRequestCodec getAddRequest() {
        return (AddRequestCodec)this.ldapMessage;
    }

    public AddResponseCodec getAddResponse() {
        return (AddResponseCodec)this.ldapMessage;
    }

    public BindRequestCodec getBindRequest() {
        return (BindRequestCodec)this.ldapMessage;
    }

    public BindResponseCodec getBindResponse() {
        return (BindResponseCodec)this.ldapMessage;
    }

    public CompareRequestCodec getCompareRequest() {
        return (CompareRequestCodec)this.ldapMessage;
    }

    public CompareResponseCodec getCompareResponse() {
        return (CompareResponseCodec)this.ldapMessage;
    }

    public DelRequestCodec getDelRequest() {
        return (DelRequestCodec)this.ldapMessage;
    }

    public DelResponseCodec getDelResponse() {
        return (DelResponseCodec)this.ldapMessage;
    }

    public ExtendedRequestCodec getExtendedRequest() {
        return (ExtendedRequestCodec)this.ldapMessage;
    }

    public ExtendedResponseCodec getExtendedResponse() {
        return (ExtendedResponseCodec)this.ldapMessage;
    }

    public IntermediateResponseCodec getIntermediateResponse() {
        return (IntermediateResponseCodec)this.ldapMessage;
    }

    public ModifyRequestCodec getModifyRequest() {
        return (ModifyRequestCodec)this.ldapMessage;
    }

    public ModifyResponseCodec getModifyResponse() {
        return (ModifyResponseCodec)this.ldapMessage;
    }

    public ModifyDNRequestCodec getModifyDnRequest() {
        return (ModifyDNRequestCodec)this.ldapMessage;
    }

    public ModifyDNResponseCodec getModifyDnResponse() {
        return (ModifyDNResponseCodec)this.ldapMessage;
    }

    public SearchRequestCodec getSearchRequest() {
        return (SearchRequestCodec)this.ldapMessage;
    }

    public SearchResultEntryCodec getSearchResultEntry() {
        return (SearchResultEntryCodec)this.ldapMessage;
    }

    public SearchResultReferenceCodec getSearchResultReference() {
        return (SearchResultReferenceCodec)this.ldapMessage;
    }

    public SearchResultDoneCodec getSearchResultDone() {
        return (SearchResultDoneCodec)this.ldapMessage;
    }

    public UnBindRequestCodec getUnbindRequest() {
        return (UnBindRequestCodec)this.ldapMessage;
    }

    public void setLdapMessage(LdapMessageCodec ldapMessage) {
        this.ldapMessage = ldapMessage;
    }

    public void clean() {
        super.clean();
        this.ldapMessage = null;
        this.messageId = 0;
        this.currentControl = null;
        this.decodeBytes = 0;
    }

    public boolean isBinary(String id) {
        return this.binaryAttributeDetector.isBinary(id);
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public AbstractControl getCurrentControl() {
        return this.currentControl;
    }

    public void setCurrentControl(AbstractControl currentControl) {
        this.currentControl = currentControl;
    }
}

