/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.compare;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;

public class CompareRequestCodec
extends LdapMessageCodec {
    private DN entry;
    private String attributeDesc;
    private Object assertionValue;
    private int compareRequestLength;
    private int avaLength;

    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.COMPARE_REQUEST;
    }

    public String getMessageTypeName() {
        return "COMPARE_REQUEST";
    }

    public DN getEntry() {
        return this.entry;
    }

    public void setEntry(DN entry) {
        this.entry = entry;
    }

    public Object getAssertionValue() {
        return this.assertionValue;
    }

    public void setAssertionValue(Object assertionValue) {
        this.assertionValue = assertionValue;
    }

    public String getAttributeDesc() {
        return this.attributeDesc == null ? "" : this.attributeDesc;
    }

    public void setAttributeDesc(String attributeDesc) {
        this.attributeDesc = attributeDesc;
    }

    protected int computeLengthProtocolOp() {
        this.compareRequestLength = 1 + TLV.getNbBytes((int)DN.getNbBytes(this.entry)) + DN.getNbBytes(this.entry);
        int attributeDescLength = StringTools.getBytesUtf8(this.attributeDesc).length;
        this.avaLength = 1 + TLV.getNbBytes((int)attributeDescLength) + attributeDescLength;
        if (this.assertionValue instanceof String) {
            int assertionValueLength = StringTools.getBytesUtf8((String)this.assertionValue).length;
            this.avaLength += 1 + TLV.getNbBytes((int)assertionValueLength) + assertionValueLength;
        } else {
            this.avaLength += 1 + TLV.getNbBytes((int)((byte[])this.assertionValue).length) + ((byte[])this.assertionValue).length;
        }
        this.compareRequestLength += 1 + TLV.getNbBytes((int)this.avaLength) + this.avaLength;
        return 1 + TLV.getNbBytes((int)this.compareRequestLength) + this.compareRequestLength;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)110);
            buffer.put(TLV.getBytes((int)this.compareRequestLength));
            Value.encode((ByteBuffer)buffer, (byte[])DN.getBytes(this.entry));
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.avaLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((String)"ERR_04005", (Object[])new Object[0]));
        }
        Value.encode((ByteBuffer)buffer, (String)this.attributeDesc);
        if (this.assertionValue instanceof String) {
            Value.encode((ByteBuffer)buffer, (String)((String)this.assertionValue));
        } else {
            Value.encode((ByteBuffer)buffer, (byte[])((byte[])this.assertionValue));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Compare request\n");
        sb.append("        Entry : '").append(this.entry).append("'\n");
        sb.append("        Attribute description : '").append(this.attributeDesc).append("'\n");
        sb.append("        Attribute value : '").append(StringTools.dumpObject(this.assertionValue)).append('\'');
        return this.toString(sb.toString());
    }
}

