/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations.gracefulShutdown;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IAction;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.extended.operations.gracefulShutdown.GracefulShutdown;
import org.apache.directory.shared.ldap.codec.extended.operations.gracefulShutdown.GracefulShutdownContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.gracefulShutdown.GracefulShutdownStatesEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulShutdownGrammar
extends AbstractGrammar {
    static final Logger log = LoggerFactory.getLogger(GracefulShutdownGrammar.class);
    static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new GracefulShutdownGrammar();

    private GracefulShutdownGrammar() {
        this.name = GracefulShutdownGrammar.class.getName();
        this.statesEnum = GracefulShutdownStatesEnum.getInstance();
        this.transitions = new GrammarTransition[4][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, (IAction)new GrammarAction("Init GracefulShutdown"){

            public void action(IAsn1Container container) {
                GracefulShutdownContainer gracefulShutdownContainer = (GracefulShutdownContainer)container;
                GracefulShutdown gracefulShutdown = new GracefulShutdown();
                gracefulShutdownContainer.setGracefulShutdown(gracefulShutdown);
                gracefulShutdownContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[1][2] = new GrammarTransition(1, 2, 2, (IAction)new GrammarAction("Set Graceful Shutdown time offline"){

            public void action(IAsn1Container container) throws DecoderException {
                GracefulShutdownContainer gracefulShutdownContainer = (GracefulShutdownContainer)container;
                Value value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int timeOffline = IntegerDecoder.parse((Value)value, (int)0, (int)720);
                    if (IS_DEBUG) {
                        log.debug("Time Offline = " + timeOffline);
                    }
                    gracefulShutdownContainer.getGracefulShutdown().setTimeOffline(timeOffline);
                    gracefulShutdownContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((String)"ERR_04037", (Object[])new Object[]{StringTools.dumpBytes(value.getData())});
                    log.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[2][128] = new GrammarTransition(2, 3, 128, (IAction)new GrammarAction("Set Graceful Shutdown Delay"){

            public void action(IAsn1Container container) throws DecoderException {
                GracefulShutdownContainer gracefulShutdownContainer = (GracefulShutdownContainer)container;
                Value value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse((Value)value, (int)0, (int)86400);
                    if (IS_DEBUG) {
                        log.debug("Delay = " + delay);
                    }
                    gracefulShutdownContainer.getGracefulShutdown().setDelay(delay);
                    gracefulShutdownContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((String)"ERR_04036", (Object[])new Object[]{StringTools.dumpBytes(value.getData())});
                    log.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[1][128] = new GrammarTransition(1, 3, 128, (IAction)new GrammarAction("Set Graceful Shutdown Delay"){

            public void action(IAsn1Container container) throws DecoderException {
                GracefulShutdownContainer gracefulShutdownContainer = (GracefulShutdownContainer)container;
                Value value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse((Value)value, (int)0, (int)86400);
                    if (IS_DEBUG) {
                        log.debug("Delay = " + delay);
                    }
                    gracefulShutdownContainer.getGracefulShutdown().setDelay(delay);
                    gracefulShutdownContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((String)"ERR_04036", (Object[])new Object[]{StringTools.dumpBytes(value.getData())});
                    log.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

