/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;

public class SearchResultEntryCodec
extends LdapMessageCodec {
    private byte[] objectNameBytes;
    private Entry entry = new DefaultClientEntry();
    private EntryAttribute currentAttributeValue;
    private int searchResultEntryLength;
    private int attributesLength;
    private List<Integer> attributeLength;
    private List<Integer> valsLength;

    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.SEARCH_RESULT_ENTRY;
    }

    public String getMessageTypeName() {
        return "SEARCH_RESULT_ENTRY";
    }

    public DN getObjectName() {
        return this.entry.getDn();
    }

    public void setObjectName(DN objectName) {
        this.entry.setDn(objectName);
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public void addAttributeValues(String type) {
        this.currentAttributeValue = new DefaultClientAttribute(type);
        try {
            this.entry.put(this.currentAttributeValue);
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
    }

    public void addAttributeValue(Object value) {
        if (value instanceof String) {
            this.currentAttributeValue.add((String)value);
        } else {
            this.currentAttributeValue.add(new byte[][]{(byte[])value});
        }
    }

    protected int computeLengthProtocolOp() {
        this.objectNameBytes = StringTools.getBytesUtf8(this.entry.getDn().getName());
        this.searchResultEntryLength = 1 + TLV.getNbBytes((int)this.objectNameBytes.length) + this.objectNameBytes.length;
        this.attributesLength = 0;
        if (this.entry != null && this.entry.size() != 0) {
            this.attributeLength = new LinkedList<Integer>();
            this.valsLength = new LinkedList<Integer>();
            for (EntryAttribute attribute : this.entry) {
                int localAttributeLength = 0;
                int localValuesLength = 0;
                int idLength = attribute.getId().getBytes().length;
                localAttributeLength = 1 + TLV.getNbBytes((int)idLength) + idLength;
                if (attribute.size() != 0) {
                    if (attribute.size() > 0) {
                        localValuesLength = 0;
                        for (Value value : attribute) {
                            byte[] binaryValue = value.getBytes();
                            localValuesLength += 1 + TLV.getNbBytes((int)binaryValue.length) + binaryValue.length;
                        }
                        localAttributeLength += 1 + TLV.getNbBytes((int)localValuesLength) + localValuesLength;
                    } else {
                        localAttributeLength += 2;
                    }
                } else {
                    localAttributeLength += 2;
                }
                this.attributesLength += 1 + TLV.getNbBytes((int)localAttributeLength) + localAttributeLength;
                this.attributeLength.add(localAttributeLength);
                this.valsLength.add(localValuesLength);
            }
        }
        this.searchResultEntryLength += 1 + TLV.getNbBytes((int)this.attributesLength) + this.attributesLength;
        return 1 + TLV.getNbBytes((int)this.searchResultEntryLength) + this.searchResultEntryLength;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)100);
            buffer.put(TLV.getBytes((int)this.searchResultEntryLength));
            org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (byte[])this.objectNameBytes);
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.attributesLength));
            if (this.entry != null && this.entry.size() != 0) {
                int attributeNumber = 0;
                for (EntryAttribute attribute : this.entry) {
                    buffer.put((byte)48);
                    int localAttributeLength = this.attributeLength.get(attributeNumber);
                    buffer.put(TLV.getBytes((int)localAttributeLength));
                    org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (byte[])Asn1StringUtils.asciiStringToByte((String)attribute.getUpId()));
                    buffer.put((byte)49);
                    int localValuesLength = this.valsLength.get(attributeNumber);
                    buffer.put(TLV.getBytes((int)localValuesLength));
                    if (attribute.size() != 0 && attribute.size() > 0) {
                        for (Value value : attribute) {
                            if (!value.isBinary()) {
                                org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (String)value.getString());
                                continue;
                            }
                            org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (byte[])value.getBytes());
                        }
                    }
                    ++attributeNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((String)"ERR_04005", (Object[])new Object[0]));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Search Result Entry\n");
        sb.append("        entry\n");
        if (this.entry == null || this.entry.size() == 0) {
            sb.append("            No entry\n");
        } else {
            sb.append(this.entry);
        }
        return sb.toString();
    }

    public String getCurrentAttributeValueType() {
        return this.currentAttributeValue.getId();
    }
}

