/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.exception;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapOperationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class LdapSchemaViolationException
extends LdapOperationException {
    static final long serialVersionUID = 1L;

    public LdapSchemaViolationException(ResultCodeEnum resultCode, String message) {
        super(message);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapSchemaViolationException(ResultCodeEnum resultCode) {
        super((String)null);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    private void checkResultCode(ResultCodeEnum resultCode) {
        switch (resultCode) {
            case OBJECT_CLASS_VIOLATION: 
            case NOT_ALLOWED_ON_RDN: 
            case OBJECT_CLASS_MODS_PROHIBITED: {
                return;
            }
        }
        throw new IllegalArgumentException(I18n.err((String)"ERR_04140", (Object[])new Object[]{resultCode}));
    }
}

