
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the ComparisonFunctions.java template.
 */

@SuppressWarnings("unused")
public class GCompareTimeVsTime {



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareTimeVsTimeNullHigh implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {



      out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareTimeVsTimeNullLow implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {



      out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareTimeVsNullableTimeNullHigh implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param NullableTimeHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = -1;
        break outside;
      }


      out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareTimeVsNullableTimeNullLow implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param NullableTimeHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = 1;
        break outside;
      }


      out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableTimeVsTimeNullHigh implements DrillSimpleFunc {

    @Param NullableTimeHolder left;
    @Param TimeHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = 1;
          break outside;
        }


      out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableTimeVsTimeNullLow implements DrillSimpleFunc {

    @Param NullableTimeHolder left;
    @Param TimeHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = -1;
          break outside;
        }


      out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableTimeVsNullableTimeNullHigh implements DrillSimpleFunc {

    @Param NullableTimeHolder left;
    @Param NullableTimeHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = 1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = -1;
          break outside;
        }


      out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableTimeVsNullableTimeNullLow implements DrillSimpleFunc {

    @Param NullableTimeHolder left;
    @Param NullableTimeHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = -1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = 1;
          break outside;
        }


      out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);

      } // outside
    }
  }

   @FunctionTemplate(names = {"less_than", "<"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanTimeVsTime implements DrillSimpleFunc {

      @Param TimeHolder left;
      @Param TimeHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          out.value = left.value < right.value ? 1 : 0;

      }
  }

  @FunctionTemplate(names = {"less_than_or_equal_to", "<="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanEqTimeVsTime implements DrillSimpleFunc {

      @Param TimeHolder left;
      @Param TimeHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          out.value = left.value <= right.value ? 1 : 0;

    }
  }

  @FunctionTemplate(names = {"greater_than", ">"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanTimeVsTime implements DrillSimpleFunc {

      @Param TimeHolder left;
      @Param TimeHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          out.value = left.value > right.value ? 1 : 0;

    }
  }

  @FunctionTemplate(names = {"greater_than_or_equal_to", ">="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanEqTimeVsTime implements DrillSimpleFunc {

      @Param TimeHolder left;
      @Param TimeHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          out.value = left.value >= right.value ? 1 : 0;

      }
  }

  @FunctionTemplate(names = {"equal", "==", "="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class EqualsTimeVsTime implements DrillSimpleFunc {

      @Param TimeHolder left;
      @Param TimeHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          out.value = left.value == right.value ? 1 : 0;

      }
  }

  @FunctionTemplate(names = {"not_equal", "<>", "!="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class NotEqualsTimeVsTime implements DrillSimpleFunc {

      @Param TimeHolder left;
      @Param TimeHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          out.value = left.value != right.value ? 1 : 0;

      }
  }

}


 



