
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
/*
 * This class is generated using freemarker and the AggrTypeFunctions3.java template.
 */


package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;

@SuppressWarnings("unused")

public class StdDevPopFunctions {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(StdDevPopFunctions.class);


@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class BigIntStdDevPop implements DrillAggFunc{

  @Param BigIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableBigIntStdDevPop implements DrillAggFunc{

  @Param NullableBigIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class IntStdDevPop implements DrillAggFunc{

  @Param IntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableIntStdDevPop implements DrillAggFunc{

  @Param NullableIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class SmallIntStdDevPop implements DrillAggFunc{

  @Param SmallIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableSmallIntStdDevPop implements DrillAggFunc{

  @Param NullableSmallIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class TinyIntStdDevPop implements DrillAggFunc{

  @Param TinyIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableTinyIntStdDevPop implements DrillAggFunc{

  @Param NullableTinyIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt1StdDevPop implements DrillAggFunc{

  @Param UInt1Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt1StdDevPop implements DrillAggFunc{

  @Param NullableUInt1Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt2StdDevPop implements DrillAggFunc{

  @Param UInt2Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt2StdDevPop implements DrillAggFunc{

  @Param NullableUInt2Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt4StdDevPop implements DrillAggFunc{

  @Param UInt4Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt4StdDevPop implements DrillAggFunc{

  @Param NullableUInt4Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt8StdDevPop implements DrillAggFunc{

  @Param UInt8Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt8StdDevPop implements DrillAggFunc{

  @Param NullableUInt8Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class Float4StdDevPop implements DrillAggFunc{

  @Param Float4Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableFloat4StdDevPop implements DrillAggFunc{

  @Param NullableFloat4Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class Float8StdDevPop implements DrillAggFunc{

  @Param Float8Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(name = "stddev_pop", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableFloat8StdDevPop implements DrillAggFunc{

  @Param NullableFloat8Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 1)
        out.value = Math.sqrt((dev.value / (count.value - 1)));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}


}
