
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl.gcast;


import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserBitShared.DrillPBError;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.common.exceptions.*;
import org.apache.drill.exec.exception.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;

import org.apache.drill.exec.exception.OutOfMemoryException;

import com.sun.codemodel.JType;
import com.sun.codemodel.JCodeModel;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.drill.exec.util.Text;

import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import javax.inject.Inject;






import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.expr.annotations.Workspace;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;

import java.nio.ByteBuffer;

/*
 * This class is generated using freemarker and the Decimal/CastVarCharDecimal.java template.
 */

@SuppressWarnings("unused")
@FunctionTemplate(name ="castEmptyStringNullableVarBinaryToNULLABLEDECIMAL18", scope = FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=NullHandling.INTERNAL)
public class CastEmptyStringNullableVarBinaryToNullableDecimal18 implements DrillSimpleFunc {
    @Param NullableVarBinaryHolder in;
    @Param BigIntHolder precision;
    @Param BigIntHolder scale;

    @Output NullableDecimal18Holder out;

    public void setup() {
    }

    public void eval() {
        // Check if the input is null or empty string
        if( in.end == in.start) {
            out.isSet = 0;
            return;
        }
        out.isSet = 1;

        // Assign the scale and precision
        out.scale = (int) scale.value;
        out.precision = (int) precision.value;

        int readIndex = in.start;
        int endIndex  = in.end;


        // Starting position of fractional part
        int scaleIndex = -1;
        // true if we have a negative sign at the beginning
        boolean negative = false;

        // Check the first byte for '-'
        byte next = (in.buffer.getByte(readIndex));

        // If its a negative number
        if (next == '-') {
            negative = true;
            readIndex++;
        }


        /* Below two fields are used to compute if the precision is sufficient to store
         * the scale along with the integer digits in the string
         */
        int integerStartIndex = readIndex;
        int integerEndIndex = endIndex;
        boolean leadingDigitFound = false;
        boolean round = false;

        int radix = 10;

        // Start parsing the digits
        while (readIndex < endIndex) {
            next = in.buffer.getByte(readIndex++);

            if (next == '.') {
                scaleIndex = readIndex;
                // Integer end index is just before the scale part begins
                integerEndIndex = scaleIndex - 1;
                // If the number of fractional digits is > scale specified we might have to truncate
                if ((scaleIndex + out.scale) < endIndex ) {
                    endIndex = scaleIndex + out.scale;
                    round    = true;
                }
                continue;
            } else {
                // If its not a '.' we expect only numbers
                next = (byte) Character.digit(next, radix);
            }

            if (next == -1) {
                // not a valid digit
                byte[] buf = new byte[in.end - in.start];
                in.buffer.getBytes(in.start, buf, 0, in.end - in.start);
                throw new org.apache.drill.common.exceptions.DrillRuntimeException(new String(buf, com.google.common.base.Charsets.UTF_8));
            } else if (leadingDigitFound == false) {
                if (next == 0) {
                    // Ignore the leading zeroes while validating if input digits will fit within the given precision
                    integerStartIndex++;
                } else {
                    leadingDigitFound = true;
                }
            }
            out.value *= radix;
            out.value += next;
        }

        // Check if the provided precision is enough to store the given input
        if (((integerEndIndex - integerStartIndex) + out.scale) > out.precision) {
            byte[] buf = new byte[in.end - in.start];
            in.buffer.getBytes(in.start, buf, 0, in.end - in.start);
            throw new org.apache.drill.common.exceptions.DrillRuntimeException("Precision is insufficient for the provided input: " + new String(buf, com.google.common.base.Charsets.UTF_8) + " Precision: " + out.precision +
                                                                               " Total Digits: " + (out.scale + (integerEndIndex - integerStartIndex)));
            // TODO:  Use JDK's java.nio.charset.StandardCharsets.UTF_8.
        }

        // Check if we need to round up
        if (round == true) {
            next = in.buffer.getByte(endIndex);
            next = (byte) Character.digit(next, radix);
            if (next == -1) {
                // not a valid digit
                byte[] buf = new byte[in.end - in.start];
                in.buffer.getBytes(in.start, buf, 0, in.end - in.start);
                throw new org.apache.drill.common.exceptions.DrillRuntimeException(new String(buf, com.google.common.base.Charsets.UTF_8));
            }
            if (next > 4) {
                out.value++;
            }
        }

        // Number of fractional digits in the input
        int fractionalDigits = (scaleIndex == -1) ? 0 : ((endIndex - scaleIndex));

        // Pad the number with zeroes if number of fractional digits is less than scale
        if (fractionalDigits < scale.value) {
            out.value = (long) (org.apache.drill.exec.util.DecimalUtility.adjustScaleMultiply(out.value, (int) (scale.value - fractionalDigits)));
        }

        // Negate the number if we saw a -ve sign
        if (negative == true) {
            out.value *= -1;
        }
    }
}

 

  

