/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.felix.webconsole.internal.core.BaseUpdateInstallHelper;
import org.apache.felix.webconsole.internal.obr.DeployerThread;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;

abstract class UpdateHelper
extends BaseUpdateInstallHelper {
    private final Bundle bundle;
    static /* synthetic */ Class class$org$osgi$service$obr$RepositoryAdmin;

    UpdateHelper(Bundle bundle, boolean refreshPackages) {
        this(bundle, null, refreshPackages);
    }

    UpdateHelper(Bundle bundle, File bundleFile, boolean refreshPackages) {
        super("Background Update " + bundle.getSymbolicName() + " (" + bundle.getBundleId() + ")", bundleFile, refreshPackages);
        this.bundle = bundle;
    }

    protected Bundle doRun(InputStream bundleStream) throws BundleException {
        this.bundle.update(bundleStream);
        return this.bundle;
    }

    protected Bundle doRun() throws BundleException, IOException {
        if (this.getBundleFile() != null) {
            return super.doRun();
        }
        if (this.updateFromBundleLocation()) {
            return this.bundle;
        }
        if (this.bundle.getSymbolicName() == null) {
            throw new BundleException("Cannot update bundle: Symbolic Name is required for OBR update");
        }
        if (this.updateFromOBR()) {
            return this.bundle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateFromBundleLocation() throws BundleException {
        String location = this.bundle.getLocation();
        this.getLog().log(4, "Trying to update from bundle location " + location);
        InputStream input = null;
        try {
            URL locationURL = new URL(location);
            input = locationURL.openStream();
            if (input != null) {
                this.doRun(input);
                this.getLog().log(3, "Bundle updated from bundle location " + location);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException ioe) {
            this.getLog().log(4, "Update failure from bundle location " + location, ioe);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean updateFromOBR() {
        String filter;
        Resource[] resources;
        Resource resource;
        RepositoryAdmin ra = (RepositoryAdmin)this.getService((class$org$osgi$service$obr$RepositoryAdmin == null ? (class$org$osgi$service$obr$RepositoryAdmin = UpdateHelper.class$("org.osgi.service.obr.RepositoryAdmin")) : class$org$osgi$service$obr$RepositoryAdmin).getName());
        if (ra == null) {
            this.getLog().log(4, "Cannot updated from OSGi Bundle Repository: Service not available");
            return false;
        }
        this.getLog().log(4, "Trying to update from OSGi Bundle Repository");
        Resolver resolver = ra.resolver();
        String version = (String)this.bundle.getHeaders().get("Bundle-Version");
        if (version == null) {
            version = "0.0.0";
        }
        if ((resource = this.selectHighestVersion(resources = ra.discoverResources(filter = "(&(symbolicname=" + this.bundle.getSymbolicName() + ")(!(version=" + version + "))(version>=" + version + "))"))) == null) {
            this.getLog().log(3, "Nothing to update, OSGi Bundle Repository does not provide more recent version");
            return false;
        }
        resolver.add(resource);
        if (!resolver.resolve()) {
            DeployerThread.logRequirements(this.getLog(), "Cannot updated bundle from OBR due to unsatisfied requirements", resolver.getUnsatisfiedRequirements());
            return false;
        }
        DeployerThread.logResource(this.getLog(), "Installing Requested Resources", resolver.getAddedResources());
        DeployerThread.logResource(this.getLog(), "Installing Required Resources", resolver.getRequiredResources());
        DeployerThread.logResource(this.getLog(), "Installing Optional Resources", resolver.getOptionalResources());
        resolver.deploy(true);
        this.getLog().log(3, "Bundle updated from OSGi Bundle Repository");
        return true;
    }

    private Resource selectHighestVersion(Resource[] candidates) {
        if (candidates == null || candidates.length == 0) {
            return null;
        }
        if (candidates.length == 1) {
            return candidates[0];
        }
        Resource best = candidates[0];
        for (int i = 1; i < candidates.length; ++i) {
            if (best.getVersion().compareTo((Object)candidates[i].getVersion()) >= 0) continue;
            best = candidates[i];
        }
        return best;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

