/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.obr;

import org.apache.felix.webconsole.internal.Logger;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;

public class DeployerThread
extends Thread {
    private final Resolver obrResolver;
    private final Logger logger;
    private final boolean startBundles;

    public DeployerThread(Resolver obrResolver, Logger logger, boolean startBundles) {
        this(obrResolver, logger, startBundles, "OBR Bundle Deployer");
    }

    public DeployerThread(Resolver obrResolver, Logger logger, boolean startBundles, String name) {
        super(name);
        this.obrResolver = obrResolver;
        this.logger = logger;
        this.startBundles = startBundles;
    }

    public void run() {
        try {
            if (this.obrResolver.resolve()) {
                DeployerThread.logResource(this.logger, "Installing Requested Resources", this.obrResolver.getAddedResources());
                DeployerThread.logResource(this.logger, "Installing Required Resources", this.obrResolver.getRequiredResources());
                DeployerThread.logResource(this.logger, "Installing Optional Resources", this.obrResolver.getOptionalResources());
                this.obrResolver.deploy(this.startBundles);
            } else {
                DeployerThread.logRequirements(this.logger, "Cannot Install requested bundles due to unsatisfied requirements", this.obrResolver.getUnsatisfiedRequirements());
            }
        }
        catch (Exception ie) {
            Throwable cause = ie.getCause() != null ? ie.getCause() : ie;
            this.logger.log(1, "Cannot install bundles", cause);
        }
    }

    public static void logResource(Logger logger, String message, Resource[] res) {
        if (res != null && res.length > 0) {
            logger.log(3, message);
            for (int i = 0; i < res.length; ++i) {
                logger.log(3, "  " + i + ": " + res[i].getSymbolicName() + ", " + res[i].getVersion());
            }
        }
    }

    public static void logRequirements(Logger logger, String message, Requirement[] req) {
        logger.log(1, message);
        for (int i = 0; req != null && i < req.length; ++i) {
            String moreInfo = req[i].getComment();
            if (moreInfo == null) {
                moreInfo = req[i].getFilter().toString();
            }
            logger.log(1, "  " + i + ": " + req[i].getName() + " (" + moreInfo + ")");
        }
    }
}

