/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.obr;

import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.Action;
import org.apache.felix.webconsole.internal.obr.AbstractObrPlugin;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.RepositoryAdmin;

public class RefreshRepoAction
extends AbstractObrPlugin
implements Action {
    public static final String NAME = "refreshOBR";
    public static final String PARAM_REPO = "repository";

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return NAME;
    }

    public boolean performAction(HttpServletRequest request, HttpServletResponse response) {
        RepositoryAdmin repoAdmin = this.getRepositoryAdmin();
        if (repoAdmin != null) {
            String repositoryURL = request.getParameter(PARAM_REPO);
            Repository[] repos = repoAdmin.listRepositories();
            Repository repo = this.getRepository(repos, repositoryURL);
            URL repoURL = null;
            if (repo != null) {
                repoURL = repo.getURL();
            } else {
                try {
                    repoURL = new URL(repositoryURL);
                }
                catch (Throwable t) {
                    this.getLog().log(1, "RefreshRepoAction: Submitted URL " + repositoryURL + " is invalid: " + t.getMessage());
                }
            }
            if (repoURL != null) {
                if (request.getParameter("remove") != null) {
                    try {
                        repoAdmin.removeRepository(repoURL);
                        this.getLog().log(3, "RefreshRepoAction: Removed repository " + repositoryURL);
                    }
                    catch (Exception e) {
                        this.getLog().log(1, "RefreshRepoAction: Failed removing repository " + repositoryURL, e);
                    }
                } else {
                    try {
                        repoAdmin.addRepository(repoURL);
                        this.getLog().log(3, "RefreshRepoAction: Added repository " + repositoryURL);
                    }
                    catch (Exception e) {
                        this.getLog().log(1, "RefreshRepoAction: Failed adding repository " + repositoryURL, e);
                    }
                }
            }
        }
        return true;
    }

    private Repository getRepository(Repository[] repos, String repositoryUrl) {
        if (repositoryUrl == null || repositoryUrl.length() == 0) {
            return null;
        }
        for (int i = 0; i < repos.length; ++i) {
            if (!repositoryUrl.equals(repos[i].getURL().toString())) continue;
            return repos[i];
        }
        return null;
    }
}

