/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.File;
import java.io.InputStream;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.internal.core.BaseUpdateInstallHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;

class UpdateHelper
extends BaseUpdateInstallHelper {
    private final Bundle bundle;

    UpdateHelper(SimpleWebConsolePlugin plugin, Bundle bundle, boolean refreshPackages) {
        this(plugin, bundle, null, refreshPackages);
    }

    UpdateHelper(SimpleWebConsolePlugin plugin, Bundle bundle, File bundleFile, boolean refreshPackages) {
        super(plugin, "Background Update " + bundle.getSymbolicName() + " (" + bundle.getBundleId() + ")", bundleFile, refreshPackages);
        this.bundle = bundle;
    }

    protected Bundle doRun(InputStream bundleStream) throws BundleException {
        this.bundle.update(bundleStream);
        return this.bundle;
    }

    protected Bundle getTargetBundle() {
        return this.bundle;
    }

    protected Bundle doRun() throws Exception {
        if (this.getBundleFile() != null) {
            return super.doRun();
        }
        if (this.updateFromBundleLocation()) {
            return this.bundle;
        }
        if (this.bundle.getSymbolicName() == null) {
            throw new BundleException("Cannot update bundle: Symbolic Name is required for OBR update");
        }
        if (this.updateFromFelixOBR()) {
            return this.bundle;
        }
        if (this.updateFromOsgiOBR()) {
            return this.bundle;
        }
        return null;
    }

    private boolean updateFromBundleLocation() {
        this.getLog().log(4, "Trying to update with Bundle.update()");
        try {
            this.bundle.update();
            this.getLog().log(3, "Bundle updated from bundle provided (update) location");
            return true;
        }
        catch (Throwable ioe) {
            this.getLog().log(4, "Update failure using Bundle.update()", ioe);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean updateFromFelixOBR() {
        RepositoryAdmin ra = (RepositoryAdmin)this.getService("org.apache.felix.bundlerepository.RepositoryAdmin");
        if (ra == null) {
            this.getLog().log(4, "Cannot updated from OSGi Bundle Repository: Service not available");
            return false;
        }
        this.getLog().log(4, "Trying to update from OSGi Bundle Repository (Apache Felix API)");
        org.apache.felix.bundlerepository.Resolver resolver = ra.resolver();
        String version = (String)this.bundle.getHeaders().get("Bundle-Version");
        if (version == null) {
            version = "0.0.0";
        }
        String filter = "(&(symbolicname=" + this.bundle.getSymbolicName() + ")(!(version=" + version + "))(version>=" + version + "))";
        Requirement req = ra.getHelper().requirement(this.bundle.getSymbolicName(), filter);
        org.apache.felix.bundlerepository.Resource[] resources = ra.discoverResources(new Requirement[]{req});
        org.apache.felix.bundlerepository.Resource resource = this.selectHighestVersion(resources);
        if (resource == null) {
            this.getLog().log(3, "Nothing to update, OSGi Bundle Repository does not provide more recent version");
            return false;
        }
        resolver.add(resource);
        if (!resolver.resolve()) {
            this.logRequirements("Cannot updated bundle from OBR due to unsatisfied requirements", resolver.getUnsatisfiedRequirements());
            return false;
        }
        this.logResource("Installing Requested Resources", resolver.getAddedResources());
        this.logResource("Installing Required Resources", resolver.getRequiredResources());
        this.logResource("Installing Optional Resources", resolver.getOptionalResources());
        resolver.deploy(16);
        this.getLog().log(3, "Bundle updated from OSGi Bundle Repository");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean updateFromOsgiOBR() {
        String filter;
        Resource[] resources;
        Resource resource;
        org.osgi.service.obr.RepositoryAdmin ra = (org.osgi.service.obr.RepositoryAdmin)this.getService("org.osgi.service.obr.RepositoryAdmin");
        if (ra == null) {
            this.getLog().log(4, "Cannot updated from OSGi Bundle Repository: Service not available");
            return false;
        }
        this.getLog().log(4, "Trying to update from OSGi Bundle Repository (OSGi API)");
        Resolver resolver = ra.resolver();
        String version = (String)this.bundle.getHeaders().get("Bundle-Version");
        if (version == null) {
            version = "0.0.0";
        }
        if ((resource = this.selectHighestVersion(resources = ra.discoverResources(filter = "(&(symbolicname=" + this.bundle.getSymbolicName() + ")(!(version=" + version + "))(version>=" + version + "))"))) == null) {
            this.getLog().log(3, "Nothing to update, OSGi Bundle Repository does not provide more recent version");
            return false;
        }
        resolver.add(resource);
        if (!resolver.resolve()) {
            this.logRequirements("Cannot updated bundle from OBR due to unsatisfied requirements", resolver.getUnsatisfiedRequirements());
            return false;
        }
        this.logResource("Installing Requested Resources", resolver.getAddedResources());
        this.logResource("Installing Required Resources", resolver.getRequiredResources());
        this.logResource("Installing Optional Resources", resolver.getOptionalResources());
        resolver.deploy(true);
        this.getLog().log(3, "Bundle updated from OSGi Bundle Repository");
        return true;
    }

    private org.apache.felix.bundlerepository.Resource selectHighestVersion(org.apache.felix.bundlerepository.Resource[] candidates) {
        if (candidates == null || candidates.length == 0) {
            return null;
        }
        if (candidates.length == 1) {
            return candidates[0];
        }
        org.apache.felix.bundlerepository.Resource best = candidates[0];
        for (int i = 1; i < candidates.length; ++i) {
            if (best.getVersion().compareTo(candidates[i].getVersion()) >= 0) continue;
            best = candidates[i];
        }
        return best;
    }

    private void logResource(String message, org.apache.felix.bundlerepository.Resource[] res) {
        if (res != null && res.length > 0) {
            this.getLog().log(3, message);
            for (int i = 0; i < res.length; ++i) {
                this.getLog().log(3, "  " + i + ": " + res[i].getSymbolicName() + ", " + res[i].getVersion());
            }
        }
    }

    private void logRequirements(String message, Reason[] reasons) {
        this.getLog().log(1, message);
        for (int i = 0; reasons != null && i < reasons.length; ++i) {
            String moreInfo = reasons[i].getRequirement().getComment();
            if (moreInfo == null) {
                moreInfo = reasons[i].getRequirement().getFilter().toString();
            }
            this.getLog().log(1, "  " + i + ": " + reasons[i].getRequirement().getName() + " (" + moreInfo + ")");
        }
    }

    private Resource selectHighestVersion(Resource[] candidates) {
        if (candidates == null || candidates.length == 0) {
            return null;
        }
        if (candidates.length == 1) {
            return candidates[0];
        }
        Resource best = candidates[0];
        for (int i = 1; i < candidates.length; ++i) {
            if (best.getVersion().compareTo(candidates[i].getVersion()) >= 0) continue;
            best = candidates[i];
        }
        return best;
    }

    private void logResource(String message, Resource[] res) {
        if (res != null && res.length > 0) {
            this.getLog().log(3, message);
            for (int i = 0; i < res.length; ++i) {
                this.getLog().log(3, "  " + i + ": " + res[i].getSymbolicName() + ", " + res[i].getVersion());
            }
        }
    }

    private void logRequirements(String message, org.osgi.service.obr.Requirement[] reasons) {
        this.getLog().log(1, message);
        for (int i = 0; reasons != null && i < reasons.length; ++i) {
            String moreInfo = reasons[i].getComment();
            if (moreInfo == null) {
                moreInfo = reasons[i].getFilter().toString();
            }
            this.getLog().log(1, "  " + i + ": " + reasons[i].getName() + " (" + moreInfo + ")");
        }
    }
}

