/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.avro.AvroSerializationSchema;
import org.apache.flink.formats.avro.RowDataToAvroConverters;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class AvroRowDataSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final SerializationSchema<GenericRecord> nestedSchema;
    private final RowType rowType;
    private transient Schema schema;
    private final RowDataToAvroConverters.RowDataToAvroConverter runtimeConverter;

    public AvroRowDataSerializationSchema(RowType rowType) {
        this(rowType, AvroSerializationSchema.forGeneric(AvroSchemaConverter.convertToSchema((LogicalType)rowType)), RowDataToAvroConverters.createConverter((LogicalType)rowType));
    }

    public AvroRowDataSerializationSchema(RowType rowType, SerializationSchema<GenericRecord> nestedSchema, RowDataToAvroConverters.RowDataToAvroConverter runtimeConverter) {
        this.rowType = rowType;
        this.nestedSchema = nestedSchema;
        this.runtimeConverter = runtimeConverter;
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.nestedSchema.open(context);
        this.schema = this.nestedSchema instanceof AvroSerializationSchema ? ((AvroSerializationSchema)this.nestedSchema).getSchema() : AvroSchemaConverter.convertToSchema((LogicalType)this.rowType);
    }

    public byte[] serialize(RowData row) {
        try {
            GenericRecord record = (GenericRecord)this.runtimeConverter.convert(this.schema, row);
            return this.nestedSchema.serialize((Object)record);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize row.", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroRowDataSerializationSchema that = (AvroRowDataSerializationSchema)o;
        return this.nestedSchema.equals(that.nestedSchema) && this.rowType.equals((Object)that.rowType);
    }

    public int hashCode() {
        return Objects.hash(this.nestedSchema, this.rowType);
    }
}

