/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.net.URL;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.client.program.DetachedEnvironment;

public class ContextEnvironmentFactory
implements ExecutionEnvironmentFactory {
    private final ClusterClient client;
    private final List<URL> jarFilesToAttach;
    private final List<URL> classpathsToAttach;
    private final ClassLoader userCodeClassLoader;
    private final int defaultParallelism;
    private final boolean isDetached;
    private ExecutionEnvironment lastEnvCreated;
    private String savepointPath;

    public ContextEnvironmentFactory(ClusterClient client, List<URL> jarFilesToAttach, List<URL> classpathsToAttach, ClassLoader userCodeClassLoader, int defaultParallelism, boolean isDetached, String savepointPath) {
        this.client = client;
        this.jarFilesToAttach = jarFilesToAttach;
        this.classpathsToAttach = classpathsToAttach;
        this.userCodeClassLoader = userCodeClassLoader;
        this.defaultParallelism = defaultParallelism;
        this.isDetached = isDetached;
        this.savepointPath = savepointPath;
    }

    public ExecutionEnvironment createExecutionEnvironment() {
        if (this.isDetached && this.lastEnvCreated != null) {
            throw new InvalidProgramException("Multiple enviornments cannot be created in detached mode");
        }
        ContextEnvironment contextEnvironment = this.lastEnvCreated = this.isDetached ? new DetachedEnvironment(this.client, this.jarFilesToAttach, this.classpathsToAttach, this.userCodeClassLoader, this.savepointPath) : new ContextEnvironment(this.client, this.jarFilesToAttach, this.classpathsToAttach, this.userCodeClassLoader, this.savepointPath);
        if (this.defaultParallelism > 0) {
            this.lastEnvCreated.setParallelism(this.defaultParallelism);
        }
        return this.lastEnvCreated;
    }

    public ExecutionEnvironment getLastEnvCreated() {
        return this.lastEnvCreated;
    }
}

