/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.oceanbase.database.dialect;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.dialect.AbstractDialect;
import org.apache.flink.connector.jdbc.core.database.dialect.JdbcDialectConverter;
import org.apache.flink.connector.jdbc.mysql.database.dialect.MySqlDialect;
import org.apache.flink.connector.jdbc.oceanbase.database.dialect.OceanBaseCompatibleMode;
import org.apache.flink.connector.jdbc.oceanbase.database.dialect.OceanBaseDialectConverter;
import org.apache.flink.connector.jdbc.oracle.database.dialect.OracleDialect;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class OceanBaseDialect
extends AbstractDialect {
    private static final long serialVersionUID = 1L;
    private final AbstractDialect dialect;

    public OceanBaseDialect(OceanBaseCompatibleMode compatibleMode) {
        this.dialect = compatibleMode.isMySQLMode() ? new MySqlDialect() : new OracleDialect();
    }

    public String dialectName() {
        return "OceanBase";
    }

    public Optional<String> defaultDriverName() {
        return Optional.of("com.oceanbase.jdbc.Driver");
    }

    public Set<LogicalTypeRoot> supportedTypes() {
        return EnumSet.of(LogicalTypeRoot.CHAR, new LogicalTypeRoot[]{LogicalTypeRoot.VARCHAR, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.VARBINARY, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE});
    }

    public JdbcDialectConverter getRowConverter(RowType rowType) {
        return new OceanBaseDialectConverter(rowType);
    }

    public String getLimitClause(long limit) {
        return this.dialect.getLimitClause(limit);
    }

    public String quoteIdentifier(String identifier) {
        return this.dialect.quoteIdentifier(identifier);
    }

    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] conditionFields) {
        return this.dialect.getUpsertStatement(tableName, fieldNames, conditionFields);
    }

    public Optional<AbstractDialect.Range> timestampPrecisionRange() {
        return this.dialect.timestampPrecisionRange();
    }

    public Optional<AbstractDialect.Range> decimalPrecisionRange() {
        return this.dialect.decimalPrecisionRange();
    }

    public String appendDefaultUrlProperties(String url) {
        return this.dialect.appendDefaultUrlProperties(url);
    }
}

