/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.postgres.database.catalog;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.core.database.catalog.AbstractJdbcCatalog;
import org.apache.flink.connector.jdbc.core.database.catalog.JdbcCatalogTypeMapper;
import org.apache.flink.connector.jdbc.postgres.database.catalog.PostgresTablePath;
import org.apache.flink.connector.jdbc.postgres.database.catalog.PostgresTypeMapper;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PostgresCatalog
extends AbstractJdbcCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresCatalog.class);
    public static final String DEFAULT_DATABASE = "postgres";
    private static final Set<String> builtinDatabases = new HashSet<String>(){
        {
            this.add("template0");
            this.add("template1");
        }
    };
    private static final Set<String> builtinSchemas = new HashSet<String>(){
        {
            this.add("pg_toast");
            this.add("pg_temp_1");
            this.add("pg_toast_temp_1");
            this.add("pg_catalog");
            this.add("information_schema");
        }
    };
    protected final JdbcCatalogTypeMapper dialectTypeMapper;

    @VisibleForTesting
    public PostgresCatalog(ClassLoader userClassLoader, String catalogName, String defaultDatabase, String username, String pwd, String baseUrl) {
        this(userClassLoader, catalogName, defaultDatabase, baseUrl, JdbcConnectionOptions.getBriefAuthProperties((String)username, (String)pwd));
    }

    public PostgresCatalog(ClassLoader userClassLoader, String catalogName, String defaultDatabase, String baseUrl, Properties connectProperties) {
        this(userClassLoader, catalogName, defaultDatabase, baseUrl, new PostgresTypeMapper(), connectProperties);
    }

    @Deprecated
    protected PostgresCatalog(ClassLoader userClassLoader, String catalogName, String defaultDatabase, String username, String pwd, String baseUrl, JdbcCatalogTypeMapper dialectTypeMapper) {
        this(userClassLoader, catalogName, defaultDatabase, baseUrl, dialectTypeMapper, JdbcConnectionOptions.getBriefAuthProperties((String)username, (String)pwd));
    }

    protected PostgresCatalog(ClassLoader userClassLoader, String catalogName, String defaultDatabase, String baseUrl, JdbcCatalogTypeMapper dialectTypeMapper, Properties connectProperties) {
        super(userClassLoader, catalogName, defaultDatabase, baseUrl, connectProperties);
        this.dialectTypeMapper = dialectTypeMapper;
    }

    public List<String> listDatabases() throws CatalogException {
        return this.extractColumnValuesBySQL(this.defaultUrl, "SELECT datname FROM pg_database;", 1, dbName -> !builtinDatabases.contains(dbName), new Object[0]);
    }

    protected Set<String> getBuiltinSchemas() {
        return builtinSchemas;
    }

    protected List<String> getPureTables(Connection conn, List<String> schemas) throws SQLException {
        ArrayList tables = Lists.newArrayList();
        try (PreparedStatement ps = conn.prepareStatement("SELECT * FROM information_schema.tables WHERE table_type = 'BASE TABLE' AND table_schema = ? ORDER BY table_type, table_name;");){
            for (String schema : schemas) {
                PostgresCatalog.extractColumnValuesByStatement((PreparedStatement)ps, (int)3, null, (Object[])new Object[]{schema}).stream().map(pureTable -> schema + "." + pureTable).forEach(tables::add);
            }
            ArrayList arrayList = tables;
            return arrayList;
        }
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        List<String> list;
        block16: {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)databaseName), (Object)"Database name must not be blank.");
            if (!this.databaseExists(databaseName)) {
                throw new DatabaseNotExistException(this.getName(), databaseName);
            }
            String url = this.getDatabaseUrl(databaseName);
            Connection conn = DriverManager.getConnection(url, this.connectionProperties);
            try {
                List schemas;
                try (PreparedStatement ps = conn.prepareStatement("SELECT schema_name FROM information_schema.schemata;");){
                    schemas = PostgresCatalog.extractColumnValuesByStatement((PreparedStatement)ps, (int)1, pgSchema -> !this.getBuiltinSchemas().contains(pgSchema), (Object[])new Object[0]);
                }
                list = this.getPureTables(conn, schemas);
                if (conn == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CatalogException(String.format("Failed to list tables for database %s", databaseName), (Throwable)e);
                }
            }
            conn.close();
        }
        return list;
    }

    protected DataType fromJDBCType(ObjectPath tablePath, ResultSetMetaData metadata, int colIndex) throws SQLException {
        return this.dialectTypeMapper.mapping(tablePath, metadata, colIndex);
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        List<String> tables = null;
        try {
            tables = this.listTables(tablePath.getDatabaseName());
        }
        catch (DatabaseNotExistException e) {
            return false;
        }
        return tables.contains(this.getSchemaTableName(tablePath));
    }

    protected String getTableName(ObjectPath tablePath) {
        return PostgresTablePath.fromFlinkTableName(tablePath.getObjectName()).getPgTableName();
    }

    protected String getSchemaName(ObjectPath tablePath) {
        return PostgresTablePath.fromFlinkTableName(tablePath.getObjectName()).getPgSchemaName();
    }

    protected String getSchemaTableName(ObjectPath tablePath) {
        return PostgresTablePath.fromFlinkTableName(tablePath.getObjectName()).getFullPath();
    }
}

