/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.trino.database.dialect;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.dialect.AbstractDialect;
import org.apache.flink.connector.jdbc.core.database.dialect.JdbcDialectConverter;
import org.apache.flink.connector.jdbc.trino.database.dialect.TrinoDialectConverter;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class TrinoDialect
extends AbstractDialect {
    private static final long serialVersionUID = 1L;
    private static final int MAX_TIMESTAMP_PRECISION = 12;
    private static final int MIN_TIMESTAMP_PRECISION = 1;
    private static final int MAX_DECIMAL_PRECISION = 38;
    private static final int MIN_DECIMAL_PRECISION = 1;

    public JdbcDialectConverter getRowConverter(RowType rowType) {
        return new TrinoDialectConverter(rowType);
    }

    public String getLimitClause(long limit) {
        return "LIMIT " + limit;
    }

    public Optional<String> defaultDriverName() {
        return Optional.of("io.trino.jdbc.TrinoDriver");
    }

    public String dialectName() {
        return "Trino";
    }

    public String quoteIdentifier(String identifier) {
        return identifier;
    }

    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        return Optional.empty();
    }

    public Optional<AbstractDialect.Range> decimalPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of((int)1, (int)38));
    }

    public Optional<AbstractDialect.Range> timestampPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of((int)1, (int)12));
    }

    public Set<LogicalTypeRoot> supportedTypes() {
        return EnumSet.of(LogicalTypeRoot.BOOLEAN, new LogicalTypeRoot[]{LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.VARCHAR, LogicalTypeRoot.FLOAT, LogicalTypeRoot.CHAR, LogicalTypeRoot.VARBINARY, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, LogicalTypeRoot.ARRAY, LogicalTypeRoot.MAP, LogicalTypeRoot.ROW});
    }
}

