/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.DeserializationException;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.apache.kafka.clients.consumer.ConsumerRecord;

@Internal
class DynamicKafkaDeserializationSchema
implements KafkaDeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final DeserializationSchema<RowData> keyDeserialization;
    private final DeserializationSchema<RowData> valueDeserialization;
    private final boolean hasMetadata;
    private final BufferingCollector keyCollector;
    private final OutputProjectionCollector outputCollector;
    private final TypeInformation<RowData> producedTypeInfo;
    private final boolean upsertMode;

    DynamicKafkaDeserializationSchema(int physicalArity, @Nullable DeserializationSchema<RowData> keyDeserialization, int[] keyProjection, DeserializationSchema<RowData> valueDeserialization, int[] valueProjection, boolean hasMetadata, MetadataConverter[] metadataConverters, TypeInformation<RowData> producedTypeInfo, boolean upsertMode) {
        if (upsertMode) {
            Preconditions.checkArgument((keyDeserialization != null && keyProjection.length > 0 ? 1 : 0) != 0, (Object)"Key must be set in upsert mode for deserialization schema.");
        }
        this.keyDeserialization = keyDeserialization;
        this.valueDeserialization = valueDeserialization;
        this.hasMetadata = hasMetadata;
        this.keyCollector = new BufferingCollector();
        this.outputCollector = new OutputProjectionCollector(physicalArity, keyProjection, valueProjection, metadataConverters, upsertMode);
        this.producedTypeInfo = producedTypeInfo;
        this.upsertMode = upsertMode;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        if (this.keyDeserialization != null) {
            this.keyDeserialization.open(context);
        }
        this.valueDeserialization.open(context);
    }

    @Override
    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    @Override
    public RowData deserialize(ConsumerRecord<byte[], byte[]> record) throws Exception {
        throw new IllegalStateException("A collector is required for deserializing.");
    }

    @Override
    public void deserialize(ConsumerRecord<byte[], byte[]> record, Collector<RowData> collector) throws Exception {
        if (this.keyDeserialization == null && !this.hasMetadata) {
            this.valueDeserialization.deserialize((byte[])record.value(), collector);
            return;
        }
        if (this.keyDeserialization != null) {
            this.keyDeserialization.deserialize((byte[])record.key(), (Collector)this.keyCollector);
        }
        this.outputCollector.inputRecord = record;
        this.outputCollector.physicalKeyRows = this.keyCollector.buffer;
        this.outputCollector.outputCollector = collector;
        if (record.value() == null && this.upsertMode) {
            this.outputCollector.collect(null);
        } else {
            this.valueDeserialization.deserialize((byte[])record.value(), (Collector)this.outputCollector);
        }
        this.keyCollector.buffer.clear();
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    private static final class OutputProjectionCollector
    implements Collector<RowData>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int physicalArity;
        private final int[] keyProjection;
        private final int[] valueProjection;
        private final MetadataConverter[] metadataConverters;
        private final boolean upsertMode;
        private transient ConsumerRecord<?, ?> inputRecord;
        private transient List<RowData> physicalKeyRows;
        private transient Collector<RowData> outputCollector;

        OutputProjectionCollector(int physicalArity, int[] keyProjection, int[] valueProjection, MetadataConverter[] metadataConverters, boolean upsertMode) {
            this.physicalArity = physicalArity;
            this.keyProjection = keyProjection;
            this.valueProjection = valueProjection;
            this.metadataConverters = metadataConverters;
            this.upsertMode = upsertMode;
        }

        public void collect(RowData physicalValueRow) {
            if (this.keyProjection.length == 0) {
                this.emitRow(null, (GenericRowData)physicalValueRow);
                return;
            }
            for (RowData physicalKeyRow : this.physicalKeyRows) {
                this.emitRow((GenericRowData)physicalKeyRow, (GenericRowData)physicalValueRow);
            }
        }

        public void close() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void emitRow(@Nullable GenericRowData physicalKeyRow, @Nullable GenericRowData physicalValueRow) {
            RowKind rowKind;
            if (physicalValueRow == null) {
                if (!this.upsertMode) throw new DeserializationException("Invalid null value received in non-upsert mode. Could not to set row kind for output record.");
                rowKind = RowKind.DELETE;
            } else {
                rowKind = physicalValueRow.getRowKind();
            }
            int metadataArity = this.metadataConverters.length;
            GenericRowData producedRow = new GenericRowData(rowKind, this.physicalArity + metadataArity);
            for (int keyPos = 0; keyPos < this.keyProjection.length; ++keyPos) {
                assert (physicalKeyRow != null);
                producedRow.setField(this.keyProjection[keyPos], physicalKeyRow.getField(keyPos));
            }
            if (physicalValueRow != null) {
                for (int valuePos = 0; valuePos < this.valueProjection.length; ++valuePos) {
                    producedRow.setField(this.valueProjection[valuePos], physicalValueRow.getField(valuePos));
                }
            }
            for (int metadataPos = 0; metadataPos < metadataArity; ++metadataPos) {
                producedRow.setField(this.physicalArity + metadataPos, this.metadataConverters[metadataPos].read(this.inputRecord));
            }
            this.outputCollector.collect((Object)producedRow);
        }
    }

    private static final class BufferingCollector
    implements Collector<RowData>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<RowData> buffer = new ArrayList<RowData>();

        private BufferingCollector() {
        }

        public void collect(RowData record) {
            this.buffer.add(record);
        }

        public void close() {
        }
    }

    static interface MetadataConverter
    extends Serializable {
        public Object read(ConsumerRecord<?, ?> var1);
    }
}

