/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.changelog.fs.FsStateChangelogOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.ReadableConfig;

@Internal
public interface RetryPolicy {
    public static final RetryPolicy NONE = new RetryPolicy(){

        @Override
        public long timeoutFor(int attempt) {
            return -1L;
        }

        @Override
        public long retryAfter(int failedAttempt, Exception exception) {
            return -1L;
        }

        public String toString() {
            return "none";
        }
    };

    public static RetryPolicy fromConfig(ReadableConfig config) {
        switch ((String)config.get(FsStateChangelogOptions.RETRY_POLICY)) {
            case "fixed": {
                return RetryPolicy.fixed((Integer)config.get(FsStateChangelogOptions.RETRY_MAX_ATTEMPTS), ((Duration)config.get(FsStateChangelogOptions.UPLOAD_TIMEOUT)).toMillis(), ((Duration)config.get(FsStateChangelogOptions.RETRY_DELAY_AFTER_FAILURE)).toMillis());
            }
            case "none": {
                return NONE;
            }
        }
        throw new IllegalConfigurationException("Unknown retry policy: " + (String)config.get(FsStateChangelogOptions.RETRY_POLICY));
    }

    public long timeoutFor(int var1);

    public long retryAfter(int var1, Exception var2);

    public static RetryPolicy fixed(int maxAttempts, long timeout, long delayAfterFailure) {
        return new FixedRetryPolicy(maxAttempts, timeout, delayAfterFailure);
    }

    public static class FixedRetryPolicy
    implements RetryPolicy {
        private final long timeout;
        private final int maxAttempts;
        private final long delayAfterFailure;

        FixedRetryPolicy(int maxAttempts, long timeout, long delayAfterFailure) {
            this.maxAttempts = maxAttempts;
            this.timeout = timeout;
            this.delayAfterFailure = delayAfterFailure;
        }

        @Override
        public long timeoutFor(int attempt) {
            return this.timeout;
        }

        @Override
        public long retryAfter(int attempt, Exception exception) {
            if (attempt >= this.maxAttempts) {
                return -1L;
            }
            if (exception instanceof TimeoutException) {
                return 0L;
            }
            if (exception instanceof IOException) {
                return this.delayAfterFailure;
            }
            return -1L;
        }

        public String toString() {
            return "timeout=" + this.timeout + ", maxAttempts=" + this.maxAttempts + ", delay=" + this.delayAfterFailure;
        }
    }
}

