/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.misc;

import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.ReduceOperator;

public class PiEstimation
implements Serializable {
    public static void main(String[] args) throws Exception {
        long numSamples = args.length > 0 ? Long.parseLong(args[0]) : 1000000L;
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        ReduceOperator count = env.generateSequence(1L, numSamples).map((MapFunction)new Sampler()).reduce((ReduceFunction)new SumReducer());
        long theCount = (Long)count.collect().get(0);
        System.out.println("We estimate Pi to be: " + (double)theCount * 4.0 / (double)numSamples);
    }

    public static final class SumReducer
    implements ReduceFunction<Long> {
        public Long reduce(Long value1, Long value2) {
            return value1 + value2;
        }
    }

    public static class Sampler
    implements MapFunction<Long, Long> {
        public Long map(Long value) {
            double y;
            double x = Math.random();
            return x * x + (y = Math.random()) * y < 1.0 ? 1L : 0L;
        }
    }
}

